<!DOCTYPE html>
<html lang="en">
@include('website.layouts.head')

<style>
  .carousel-inner .carousel-item img {
    transition: transform 0.3s ease; 
  }
  .carousel-inner .carousel-item img:hover {
    transform: scale(0.9); 
  }
</style>

<body class="index-page">
  @include('website.layouts.header')

  <main class="main">
    <!-- Hero Section -->
    <section id="hero" class="hero section dark-background">
      <div class="container">
        <div class="row gy-4">
          <div class="col-lg-6 order-2 order-lg-1 d-flex flex-column justify-content-center" data-aos="fade-in">
            <h1 class="my-trans">Decentralised water Solutions</h1>
            <p>6X more water in the atmosphere than there is in all rivers around the world.</p>
            <div class="d-flex">
              <a href="#about" class="btn-get-started">OUR IMPACT</a>
            </div>
          </div>
          
          <div class="col-lg-6 order-1 order-lg-2 hero-img" data-aos="zoom-out" data-aos-delay="100">
            <div id="imageCarousel" class="carousel slide carousel-fade" data-bs-ride="carousel" data-bs-interval="5000">
              <div class="carousel-inner">
                <div class="carousel-item active">
                  <img src="{{ asset('assets/web/img/landing-home.jpg') }}" 
                       class="img-fluid animated rounded" alt="Landing Home 1">
                </div>
                <div class="carousel-item">
                  <img src="{{ asset('assets/web/img/990.jpg') }}" 
                       class="img-fluid animated rounded" alt="Landing Home 2">
                </div>
                <div class="carousel-item">
                  <img src="{{ asset('assets/web/img/889.jpg') }}" 
                       class="img-fluid animated rounded" alt="Landing Home 3">
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Clients Section -->
    <section id="clients" class="clients section light-background">
      <div class="container section-title" data-aos="fade-up">
        <h2>Our Able Partners</h2>
      </div>

      <div class="swiper init-swiper">
        <script type="application/json" class="swiper-config">
          {
            "loop": true,
            "speed": 600,
            "autoplay": {
              "delay": 5000
            },
            "slidesPerView": "auto",
            "pagination": {
              "el": ".swiper-pagination",
              "type": "bullets",
              "clickable": true
            },
            "breakpoints": {
              "320": {
                "slidesPerView": 2,
                "spaceBetween": 40
              },
              "480": {
                "slidesPerView": 3,
                "spaceBetween": 60
              },
              "640": {
                "slidesPerView": 4,
                "spaceBetween": 80
              },
              "992": {
                "slidesPerView": 6,
                "spaceBetween": 120
              }
            }
          }
        </script>
        <div class="swiper-wrapper align-items-center">
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/1.png')}}" class="img-fluid" alt=""></div>
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/2.png')}}" class="img-fluid" alt=""></div>
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/3.png')}}" class="img-fluid" alt=""></div>
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/4.png')}}" class="img-fluid" alt=""></div>
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/5.png')}}" class="img-fluid" alt=""></div>
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/6.png')}}" class="img-fluid" alt=""></div>
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/1.png')}}" class="img-fluid" alt=""></div>
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/2.png')}}" class="img-fluid" alt=""></div>
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/3.png')}}" class="img-fluid" alt=""></div>
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/4.png')}}" class="img-fluid" alt=""></div>
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/5.png')}}" class="img-fluid" alt=""></div>
          <div class="swiper-slide"><img src="{{ asset('assets/web/img/partners/6.png')}}" class="img-fluid" alt=""></div>
        </div>
      </div>
    </section>

    <!-- About Section -->
    <section id="about" class="about section">
      <div class="container">
        <div class="row gy-4">
          <br><br><br>

          <div class="col-lg-6 position-relative order-lg-last video-container" style="margin-top: 130px;" data-aos="fade-up" data-aos-delay="200">
            <div id="videoCarousel" class="carousel slide" data-bs-ride="carousel">
              <!-- Carousel Indicators -->
              <div class="carousel-indicators">
                <button type="button" data-bs-target="#videoCarousel" data-bs-slide-to="0" class="active" aria-current="true"></button>
                <button type="button" data-bs-target="#videoCarousel" data-bs-slide-to="1"></button>
              </div>
            
              <!-- Carousel Inner -->
              <div class="carousel-inner">
                <!-- First Video -->
                <div class="carousel-item active">
                  <div class="video-container position-relative">
                    <img src="{{ asset('assets/web/img/doa.png')}}" class="img-fluid" alt="">
                    <a href="https://www.youtube.com/watch?v=FxZB9pRD2Bo&t=51s&ab_channel=BraveBlueWorldFoundation" class="glightbox pulsating-play-btn"></a>
                    <div class="overlay-text">
                      <h4>Netflix Documentary</h4>
                      <p>
                        Narrated by Liam Neeson, interviewed by Matt Damon - our team was very proud to feature in this documentary about water innovations all over the world.
                      </p>
                    </div>
                  </div>
                </div>
            
                <!-- Second Video -->
                <div class="carousel-item">
                  <div class="video-container position-relative">
                    <img src="{{ asset('assets/web/img/doan.jpg')}}" class="img-fluid" alt="">
                    <a href="https://youtu.be/jejZYRqCqsE" class="glightbox pulsating-play-btn"></a>
                    <div class="overlay-text">
                      <h4>People running out of water in Kenya and beyond.</h4>
                      <p>
                        We are facing an unprecedented water crisis, with global freshwater demand predicted to exceed supply by 40% and 50% in developing countries by 2030, says the UN
                      </p>
                    </div>
                  </div>
                </div>
              </div>
            
              <!-- Carousel Controls -->
              <button class="carousel-control-prev" type="button" data-bs-target="#videoCarousel" data-bs-slide="prev">
                <span class="carousel-control-prev-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Previous</span>
              </button>
              <button class="carousel-control-next" type="button" data-bs-target="#videoCarousel" data-bs-slide="next">
                <span class="carousel-control-next-icon" aria-hidden="true"></span>
                <span class="visually-hidden">Next</span>
              </button>
            </div>
          </div>

          <div class="col-lg-6 content" data-aos="fade-up" data-aos-delay="100">
            <h3>About Majik</h3>
            <p>Majik Water is a Kenyan company that specialises in air to water technologies in arid and semi arid regions</p>
            <p>
              We are a social enterprise that specializes in air to water technologies in arid and semi arid regions. We are creating a new source of affordable, clean drinking water for water scarce communities. If you have air, you can have drinking water.
            </p>
            <ul>
              <li>
                <i class="bi bi-broadcast"></i>
                <div>
                  <h5>Our Mission</h5>
                  <p>To increase access to clean drinking water in arid and semi arid regions in Kenya through use of Air to Water technologies.</p>
                </div>
              </li>
              <li>
                <i class="bi bi-check-lg"></i>
                <div>
                  <h5>Our Vision</h5>
                  <p>Creating a new source of affordable, clean drinking water for water scarce communities. If you have air, you can have drinking water</p>
                </div>
              </li>
              <li>
                <i class="bi bi-diagram-3"></i>
                <div>
                  <h5>Our Goal</h5>
                  <p>Our goal is help change lives in communities, with this we target to install 100 litre+ community devices. Be part of it</p>
                </div>
              </li>
              <li>
                <i class="bi bi-fullscreen-exit"></i>
                <div>
                  <h5>Our Impact</h5>
                  <p>20 High volume deployments. 10 small scale deployments</p>
                </div>
              </li>
            </ul>
          </div>
        </div>
      </div>
    </section>

    <!-- Awards Section -->
    <section id="awards" class="featured-services section">
      <div class="container section-title" data-aos="fade-up">
        <h2>The Prestigious Awards</h2>
      </div>

      <div class="container" data-aos="fade-up" data-aos-delay="100">
        <div class="row gy-5">
          <div class="col-xl-4 col-md-6" data-aos="zoom-in" data-aos-delay="200">
            <div class="service-item">
              <div class="img">
                <img src="{{ asset('assets/web/img/mit.png')}}" class="img-fluid" alt="">
              </div>
              <div class="details position-relative">
                <div class="icon">
                  <i class="bi bi-activity"></i>
                </div>
                <a href="https://mitwaterfoodagprize.org/" class="stretched-link">
                  <h3>MIT Water Awards</h3>
                </a>
                <p>Nurturing creative talent from across the globe to address key challenges in the water sector</p>
              </div>
            </div>
          </div>

          <div class="col-xl-4 col-md-6" data-aos="zoom-in" data-aos-delay="300">
            <div class="service-item">
              <div class="img">
                <img src="{{ asset('assets/web/img/awards/13.png')}}" class="img-fluid" alt="">
              </div>
              <div class="details position-relative">
                <div class="icon">
                  <i class="bi bi-activity"></i>
                </div>
                <a href="https://www.fuzu.com/forum/article/innovating-for-a-better-tomorrow-nairobi-innovation-week-2018" class="stretched-link">
                  <h3>Nairobi Innovation Week 2018</h3>
                </a>
                <p>Recognizing and inspiring innovators who are disrupting and transforming their societies.</p>
              </div>
            </div>
          </div>

          <div class="col-xl-4 col-md-6" data-aos="zoom-in" data-aos-delay="400">
            <div class="service-item">
              <div class="img">
                <img src="{{ asset('assets/web/img/awards/179.png')}}" class="img-fluid" alt="">
              </div>
              <div class="details position-relative">
                <div class="icon">
                  <i class="bi bi-activity"></i>
                </div>
                <a href="https://www.edf.fr/en/pulse/edf-pulse-africa-awards" class="stretched-link">
                  <h3>EDF Pulse Africa Awards</h3>
                </a>
                <p>Development of products, solutions and services aimed at supporting the continent's energy development.</p>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Team Section -->
    <section id="team" class="team section">
      <div class="container section-title" data-aos="fade-up">
        <h2>Team</h2>
        <p>Meet the Top Team behind Majik</p>
      </div>

      <div class="container">
        <div class="row gy-4">
          <div class="col-lg-4 col-md-6 d-flex align-items-stretch" data-aos="fade-up" data-aos-delay="200">
            <div class="team-member">
              <div class="member-img">
                <img src="{{ asset('assets/web/img/beth.webp')}}" class="img-fluid" alt="">
                <div class="social">
                  <a href=""><i class="bi bi-twitter-x"></i></a>
                  <a href=""><i class="bi bi-facebook"></i></a>
                  <a href=""><i class="bi bi-instagram"></i></a>
                  <a href=""><i class="bi bi-linkedin"></i></a>
                </div>
              </div>
              <div class="member-info">
                <h4>Beth Koigi / CEO</h4>
                <span>Market & Partnerships</span>
              </div>
            </div>
          </div>

          <div class="col-lg-4 col-md-6 d-flex align-items-stretch" data-aos="fade-up" data-aos-delay="300">
            <div class="team-member">
              <div class="member-img">
                <img src="{{ asset('assets/web/img/ak.webp')}}" class="img-fluid" alt="">
                <div class="social">
                  <a href=""><i class="bi bi-twitter-x"></i></a>
                  <a href=""><i class="bi bi-facebook"></i></a>
                  <a href=""><i class="bi bi-instagram"></i></a>
                  <a href=""><i class="bi bi-linkedin"></i></a>
                </div>
              </div>
              <div class="member-info">
                <h4>Anastasia Kaschenko / CTO</h4>
                <span>Technology Environmental scientist, water policy, R&D.</span>
              </div>
            </div>
          </div>

          <div class="col-lg-4 col-md-6 d-flex align-items-stretch" data-aos="fade-up" data-aos-delay="400">
            <div class="team-member">
              <div class="member-img">
                <img src="{{ asset('assets/web/img/cs.webp')}}" class="img-fluid" alt="">
                <div class="social">
                  <a href=""><i class="bi bi-twitter-x"></i></a>
                  <a href=""><i class="bi bi-facebook"></i></a>
                  <a href=""><i class="bi bi-instagram"></i></a>
                  <a href=""><i class="bi bi-linkedin"></i></a>
                </div>
              </div>
              <div class="member-info">
                <h4>Clare Sewell / COO</h4>
                <span>Finance & Strategy Oxford economist</span>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>
  
    <!-- Contact Section -->
    <section id="contact" class="contact section light-background">
      <div class="container section-title" data-aos="fade-up">
        <h2>Contact</h2>
        <p>Necessitatibus eius consequatur ex aliquid fuga eum quidem sint consectetur velit</p>
      </div>

      <div class="container" data-aos="fade-up" data-aos-delay="100">
        <div class="row gy-4">
          <div class="col-lg-6">
            <div class="row gy-4">
              <div class="col-lg-12">
                <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="200">
                  <i class="bi bi-geo-alt"></i>
                  <h3>Address</h3>
                  <p>Kabati,  Wempa, Off Thika Road Just before Kenol Town
                  </p>
                  <p>Industrial Area, Nairobi, Kenya</p>
                </div>
              </div>

              <div class="col-md-6">
                <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="300">
                  <i class="bi bi-telephone"></i>
                  <h3>Call Us</h3>
                  <p>+254 729 910 609</p>
                </div>
              </div>

              <div class="col-md-6">
                <div class="info-item d-flex flex-column justify-content-center align-items-center" data-aos="fade-up" data-aos-delay="400">
                  <i class="bi bi-envelope"></i>
                  <h3>Email Us</h3>
                  <p>hello@majikwater.co</p>
                </div>
              </div>
            </div>
          </div>

          <div class="col-lg-6">
            <form action="forms/contact.php" method="post" class="php-email-form" data-aos="fade-up" data-aos-delay="500">
              <div class="row gy-4">
                <div class="col-md-6">
                  <input type="text" name="name" class="form-control" placeholder="Your Name" required="">
                </div>

                <div class="col-md-6">
                  <input type="email" class="form-control" name="email" placeholder="Your Email" required="">
                </div>

                <div class="col-md-12">
                  <input type="text" class="form-control" name="subject" placeholder="Subject" required="">
                </div>

                <div class="col-md-12">
                  <textarea class="form-control" name="message" rows="4" placeholder="Message" required=""></textarea>
                </div>

                <div class="col-md-12 text-center">
                  <div class="loading">Loading</div>
                  <div class="error-message"></div>
                  <div class="sent-message">Your message has been sent. Thank you!</div>

                  <button type="submit">Send Message</button>
                </div>
              </div>
            </form>
          </div>
        </div>
      </div>
    </section>
  </main>

  @include('website.layouts.footer')
  @include('website.loaders.jsloader')
</body>
</html>