<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Careers</title>
    <link rel="stylesheet" href="style.css">
    <style>
      /* Reset */
*,
*::before,
*::after {
    box-sizing: border-box;
    margin: 0;
    padding: 0;
}

body {
    font-family: Arial, sans-serif;
    color: #333;
    background-color: #f7f7f7;
    line-height: 1.6;
}

/* Header */
header {
    background-color: #2c3e50;
    color: #fff;
    text-align: center;
    padding: 1rem 0;
}

header h1 {
    font-size: 2rem;
    margin-bottom: 0.5rem;
}

/* Main Content */
main {
    max-width: 1200px;
    margin: 0 auto;
    padding: 2rem;
}

.careers-section {
    text-align: center;
    padding: 2rem 1rem;
    background: #ffffff;
    box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
    border-radius: 8px;
    margin: 2rem 0;
}

.careers-section h2 {
    font-size: 2.5rem;
    color: #2c3e50;
    margin-bottom: 0.5rem;
}

.careers-section p {
    font-size: 1.2rem;
    color: #7f8c8d;
    margin-bottom: 2rem;
}

/* Job Listings */
.job-listings {
    display: flex;
    flex-wrap: wrap;
    gap: 1.5rem;
    justify-content: center;
}

.job-listing {
    background-color: #ecf0f1;
    padding: 1.5rem;
    border-radius: 8px;
    width: 100%;
    max-width: 400px;
    text-align: left;
    transition: box-shadow 0.3s;
}

.job-listing h3 {
    font-size: 1.5rem;
    color: #34495e;
    margin-bottom: 0.5rem;
}

.job-listing p {
    font-size: 1rem;
    color: #7f8c8d;
    margin-bottom: 1rem;
}

.job-listing:hover {
    box-shadow: 0 8px 16px rgba(0, 0, 0, 0.2);
}

/* Apply Button */
.apply-button {
    display: inline-block;
    text-decoration: none;
    color: #fff;
    background-color: #3498db;
    padding: 0.8rem 1.2rem;
    border-radius: 4px;
    font-weight: bold;
    transition: background-color 0.3s;
}

.apply-button:hover {
    background-color: #2980b9;
}

/* Responsive Design */
@media (max-width: 768px) {
    .careers-section h2 {
        font-size: 2rem;
    }

    .job-listings {
        flex-direction: column;
    }

    .job-listing {
        max-width: 100%;
    }
}

/* Footer */
footer {
    background-color: #2c3e50;
    color: #fff;
    text-align: center;
    padding: 1rem 0;
    font-size: 0.9rem;
    margin-top: 2rem;
}


    </style>
</head>
<body>
    <header>
        </header>

    <main>
        <section class="careers-section">
            <h2>Careers at [Company Name]</h2>
            <p>Join our team and be part of something great.</p>

            <div class="job-listings">
                <div class="job-listing">
                    <h3>Senior Front-End Engineer</h3>
                    <p>We're looking for a skilled Front-End Engineer to join our team...</p>
                    <a href="https://apply.jobboard.com/job/12345" class="apply-button">Apply Now</a>
                </div>

                <div class="job-listing">
                    <h3>Backend Developer</h3>
                    <p>We're seeking a talented Backend Developer to...</p>
                    <a href="https://apply.jobboard.com/job/67890" class="apply-button">Apply Now</a>
                </div>
            </div>
        </section>
    </main>

    <footer>
        </footer>
</body>
</html>