<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <!-- displays site properly based on user's device -->

    <link
      rel="icon"
      type="image/png"
      sizes="32x32"
      href="./assets/images/favicon-32x32.png"
    />
    <link
      href="https://fonts.googleapis.com/css?family=Inter:100,200,300,regular,500,600,700,800,900"
      rel="stylesheet"
    />
    <link rel="stylesheet" href="style.css" />
    <title>Frontend Mentor | News homepage</title>
    <style>
        :root {
  --aside-text: hsl(236, 13%, 42%);
  --aside-box: hsl(240, 100%, 5%);
  --page-color: hsl(36, 100%, 99%);
  --paragraph-color: hsl(233, 8%, 79%);
  --aside-header: hsl(35, 77%, 62%);
  --button-color: hsl(5, 85%, 63%);
}

* {
  margin: 0;
  padding: 0;
  box-sizing: border-box;
  text-decoration: none;
}

html {
  font-size: 10px;
  font-family: "Inter", sans-serif;
}
body {
  font-size: 1.6rem; /* For Responsive Layout*/
  background-color: var(--page-color);
}
.container {
  width: 100%;
  /* Setting padding and margin across the page */
  padding: 1.5rem 15rem;

  display: grid;
  gap: 2rem;

  grid-template-rows: 0.1fr 0.7fr;
  grid-template-columns: 1fr;
  grid-template-areas:
    "navigation"
    "main";
}
/* for the sidebar */
.sidebar {
  display: none;
  position: fixed;
  padding: 2rem 2rem;
  left: 30%;
  flex-direction: column;
  justify-content: flex-start;
  float: right;
  width: 70%;
  height: 100%;
  background-color: white;
  z-index: 1000;
}
.sidebar img {
  width: 3rem;
  margin-bottom: 40%;
  align-self: flex-end;
}

.sidebar ul {
  height: 23rem;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
}
.sidebar ul > li > a {
  color: var(--aside-box);
  font-weight: 500;
}
/* .container * {
  border: 2px solid red;
} */
/* content - navbar */
main {
  grid-area: main;
  display: grid;
  grid-template-rows: 0.9fr 0.1fr;
  grid-template-columns: 1fr 1fr 1fr;
  gap: 2rem;
  grid-template-areas:
    "featured featured aside"
    "featured featured aside"
    "article article article";
}

nav {
  grid-area: navigation;
  width: 100%;
  display: flex;
  justify-content: space-between;
  align-items: center;
}

/* For the sidebar */
.hamburger {
  display: none;
}
ul {
  width: 40%;
  list-style-type: none;
  display: flex;
  justify-content: space-between;
}
/* Active States */
li>a:hover{
  color: var(--button-color);
}
p {
  font-size: 1.5rem;
  font-weight: 500;
}
ul > li > a {
  color: var(--aside-text);
}

/* For the featured section */
.featured {
  grid-area: featured;
  display: grid;
  gap: 2rem;

  grid-template-rows: 1fr 0.8fr;
  grid-template-columns: 1fr 1fr;
  grid-template-areas:
    "image image"
    "image-text text";
}

.featured-img {
  grid-area: image;
  width: 100%;
  height: 100%;
  /* object-position: 15%; */
  object-fit: cover;
}
.featured-text {
  display: block;
  -webkit-transform: translate3d(0, 0, 0);
  transform: translate3d(0, 0, 0);
  grid-area: image-text;
  font-size: 6rem;
  font-weight: 800;
  width: 100%;
}

/* For the paragraph text with a button  */
.cta {
  grid-area: text;
  padding: 1rem;

  display: flex;
  flex-direction: column;
}
.cta p {
  color: var(--aside-text);
  line-height: 3rem;
}
.cta a {
  display: inline-block;
  text-transform: uppercase;
  color: var(--page-color);
  width: 20rem;
  height: 5rem;
  margin-top: 3.6rem;
  text-align: center;
  padding: 1.5rem;
  letter-spacing: 0.6rem;
  font-weight: 700;
  border: none;
  background-color: var(--button-color);
}

/* Active States */
.cta a:hover{
  background-color: var(--aside-box);
}

/* for the side content */
aside {
  height: 92%;
  grid-area: aside;
  display: flex;
  flex-direction: column;
  justify-content: space-around;
  padding: 2.5rem;
  background-color: var(--aside-box);
  color: var(--aside-text);
}
aside h1 {
  color: var(--aside-header);
  font-size: 4rem;
}
aside div:not(:last-child) {
  border-bottom: 0.1rem solid var(--paragraph-color);
  padding-bottom: 2rem;
}
aside div h2 {
  color: var(--page-color);
}
aside div h2:hover{
  color: var(--aside-header);
}
aside div p {
  padding: 1rem 1rem 0 0;
}

/* for the bottom article preview  */
.article-container {
  width: 100%;
  height: 55%;
  justify-content: space-between;
  grid-area: article;
  display: flex;
}

.article-container > div {
  width: 31%;
  height: 100%;
  display: flex;
}
.article-text {
  margin-left: 1rem;
  height: 100%;
  align-self: center;
  display: flex;
  flex-direction: column;
  justify-content: space-between;
}
.article-text h1 {
  margin-bottom: 1rem;
  font-size: 4rem;
  color: var(--paragraph-color);
}
.article-text h3 {
  margin: 0.5rem 0;
}
.article-text h3:hover{
  color: var(--button-color);
}
.article-text p {
  width: 100%;
  color: var(--aside-text);
}
/* @media screen and (max-width: 768px) {
  .container {
    padding: 0rem;
  }
} */

/* Responsiveness for the screen of 375px */
@media screen and (max-width: 48rem) {
  nav ul {
    display: none;
  }
  /* Displaying hamburger when the width is less than or equal to 375px or 37.5rem */
  .hamburger {
    display: block;
  }
  .sidebar {
    font-size: 1.8rem;
  }
  /* Container Layout */
  .container {
    grid-template-rows: 0.04fr 1fr;
    padding: 0 1.5rem;
  }
  /* Mobile Layout */
  main {
    grid-template-rows: 1fr 0.8fr 0.6fr;
    grid-template-columns: 1fr;
    grid-template-areas:
      "featured"
      "aside"
      "article";
  }
  /* Increasing font size for the aside content and the (paragraph with the text) */
  .cta p,
  aside > div > p {
    font-size: 2rem;
  }
  /* Changing layout on the hero text, paragraph and btn */
  .featured {
    grid-template-rows: 0.85fr 0.3fr 0.1fr;
    grid-template-columns: 1fr;
    grid-template-areas:
      "image"
      "image-text"
      "text";
  }
  /* .featured-img{
    height: 80%;
  } */
  .featured-text {
    font-size: 5rem;
    width: 80%;
    font-weight: 800;
  }
  .cta {
    padding: 0;
  }
  aside div:not(:last-child) {
    border-bottom: 0.1rem solid var(--paragraph-color);
    padding-bottom: 4rem;
  }
  .article-container {
    flex-direction: column;
  }
  /* Reducing font size on the mobile layout */
  .article-text > h1 {
    font-size: 4rem;
    font-weight: 700;
    margin: 0;
  }
  /* So that the article will span the width of the device */
  .article-container > div {
    width: 100%;
    height: 28%;
    margin-top: 4rem;
  }
  .article-text {
    margin-left: 2rem;
  }
  .article-text h3 {
    font-weight: 700;
    /* font-size: 1.8rem; */
    margin: 0;
  }
}
.attribution {
  font-size: 11px;
  text-align: center;
}
.attribution a {
  color: hsl(228, 45%, 44%);
}
    </style>
  </head>
  <body>
    <!-- Navigation -->
    <div class="container">
      <nav>
        <img id="logo" src="assets/img/logo.svg" alt="" />
        <ul class="desktop-navigation">
          <li><a href="">Home</a></li>
          <li><a href="">New</a></li>
          <li><a href="">Popular</a></li>
        </ul>
        <img src="assets/img/icon-menu.svg" alt="" class="sidebar-toggle hamburger">
      </nav>
      
      <!-- Sidebar -->
      <div class="sidebar">
        <img src="assets/img/icon-menu-close.svg" class="sidebar-toggle closeBtn" alt="">
        <ul>
          <li><a href="">Home</a></li>
          <li><a href="">New</a></li>
          <li><a href="">Popular</a></li>
        </ul>
      </div>

      <main>
        <!-- Featured Article -->

        <section class="featured">
          <img
            class="featured-img"
            src="assets/img/image-web-3-desktop.jpg"
            width="500px"
            alt="page icon"
          />
          <h1 class="featured-text">The Bright Future of Web 3.0?</h1>

          <div class="cta">
            <p>
              We dive into the next evolution of the web that claims to put the
              power of the platforms back into the hands of the people. But is
              it really fulfilling its promise?
            </p>
            <a href="">Read more</a>
          </div>
        </section>

        <!-- Side News -->

        <aside>
          <h1>News</h1>
          <div>
            <h2>Hydrogen VS Electric Cars</h2>
            <p>Will hydrogen-fueled cars ever catch up to EVs?</p>
          </div>
          <div>
            <h2>The Downsides of AI Artistry</h2>
            <p>
              What are the possible adverse effects of on-demand AI image
              generation?
            </p>
          </div>
          <div>
            <h2>Is VC Funding Drying Up?</h2>
            <p>
              Private funding by VC firms is down 50% YOY. We take a look at
              what that means.
            </p>
          </div>
        </aside>

        <!-- Other Articles -->

        <section class="article-container">
          <div>
            <img src="assets/images/image-retro-pcs.jpg" alt="" />
            ,
            <div class="article-text">
              <h1>01</h1>
              <h3>Reviving Retro PCs</h3>
              <p>What happens when old PCs are given modern upgrades?</p>
            </div>
          </div>
          <div>
            <img src="assets/images/image-top-laptops.jpg" alt="" />
            <div class="article-text">
              <h1>02</h1>
              <h3>Top 10 Laptops of 2022</h3>
              <p>Our best picks for various needs and budgets.</p>
            </div>
          </div>
          <div>
            <img src="assets/images/image-gaming-growth.jpg" alt="" />
            <div class="article-text">
              <h1>03</h1>
              <h3>The Growth of Gaming</h3>
              <p>How the pandemic has sparked fresh opportunities.</p>
            </div>
          </div>
        </section>
      </main>
    </div>

    <script src="script.js"></script>
  </body>
</html>