<!DOCTYPE html>
<html lang="en">
@include('web.layouts.head')

<body>

  <!--== Loader Start ==-->
  <div id="loader-overlay">
    <div class="loader">

      <img src="{{ asset('assets/web-new/assets/images/loader.svg')}}" width="80" alt="" style="fill: blue;">
    </div>
  </div>
  <!--== Loader End ==-->

  <!--== Wrapper Start ==-->
  <div class="wrapper">
    @include('web.header.nav')

    <!--== Header End ==-->

    <!--== Hero Slider Start ==-->
    <div class="remove-padding transition-none" id="home">
      <div id="rev_slider_1078_2_wrapper" class="rev_slider_wrapper fullwidthbanner-container"
        data-alias="classic4export" data-source="gallery"
        style="margin:0px auto;background-color:#000000;padding:0px;margin-top:0px;margin-bottom:0px;">
        <!-- START REVOLUTION SLIDER 5.4.1 fullwidth mode -->
        <div id="rev_slider_1078_2" class="rev_slider fullwidthabanner anno-rs" style="display:none;"
          data-version="5.4.1">
          <ul>
            <!-- SLIDE  -->
            <li data-index="rs-3045" data-transition="zoomout" data-slotamount="default" data-hideafterloop="0"
              data-hideslideonmobile="off" data-easein="default" data-easeout="default" data-masterspeed="default"
              data-rotate="0" data-saveperformance="off" data-title="" data-param1="" data-param2="" data-param3=""
              data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10=""
              data-description="">
              <!-- MAIN IMAGE -->
              <img src="{{ asset('assets/web-new/assets/images/hero.jpg')}}" alt="" class="rev-slidebg"
                data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-kenburns="off"
                data-duration="20000" data-ease="Linear.easeNone" data-scalestart="100" data-scaleend="200"
                data-offsetstart="0 0" data-offsetend="0 0" data-rotatestart="0" data-rotateend="0">
              <!-- LAYERS -->

              <!-- LAYER NR. 1 -->
              <div class="hero-text-wrap">
                <div class="tp-caption NotGeneric-Title tp-resizeme" id="slide-3045-layer-1"
                  data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['-120','-180','-180','-80']"
                  data-fontsize="['76','46','46','20']" data-lineheight="['76','46','46','20']" data-width="none"
                  data-height="none" data-whitespace="nowrap" data-type="text" data-responsive_offset="on"
                  data-frames='[{"delay":"+290","speed":2000,"frame":"0","from":"y:50px;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power4.easeOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['center','center','center','center']" data-paddingtop="[10,10,10,10]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[10,10,10,10]" data-paddingleft="[0,0,0,0]"
                  style="font-family: 'Montserrat', sans-serif;font-weight:700;">Decentralised Water <br />Solutions
                </div>

                <!-- LAYER NR. 2 -->
                <div class="tp-caption NotGeneric-Title tp-resizeme" id="slide-3045-layer-2"
                  data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['60','60','0','0']"
                  data-fontsize="['22','22','22','12']" data-lineheight="['38','38','38','20']" data-width="none"
                  data-height="none" data-whitespace="nowrap" data-type="text" data-responsive_offset="on"
                  data-frames='[{"delay":"+490","speed":2000,"frame":"0","from":"y:50px;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power4.easeOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['center','center','center','center']" data-paddingtop="[10,10,10,10]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[10,10,10,10]" data-paddingleft="[0,0,0,0]"
                  style="font-family: 'Montserrat', sans-serif;font-weight:400;">6X more water in the atmosphere than
                  there is in <br />all rivers around the world.</div>

                <!-- LAYER NR. 4 -->
                <div class="tp-caption NotGeneric-SubTitle tp-resizeme" id="slide-3045-layer-4"
                  data-x="['center','center','center','center']" data-hoffset="['-100','0','-80','50']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['180','160','120','100']"
                  data-width="none" data-height="none" data-whitespace="nowrap" data-type="text"
                  data-responsive_offset="on"
                  data-frames='[{"delay":0,"speed":2500,"frame":"0","from":"x:-50px;opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":2500,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['left','left','left','left']" data-paddingtop="[0,0,0,0]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[0,0,0,0]" data-paddingleft="[0,0,0,0]"><a
                    class="btn btn-lg btn-light btn-circle" style="padding: 20px 38px;">Explore More</a></div>

                <!-- LAYER NR. 5 -->
                <div class="tp-caption NotGeneric-SubTitle tp-resizeme" id="slide-3045-layer-5"
                  data-x="['center','center','center','center']" data-hoffset="['100','0','100','40']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['180','160','120','180']"
                  data-width="none" data-height="none" data-whitespace="nowrap" data-type="text"
                  data-responsive_offset="on"
                  data-frames='[{"delay":0,"speed":3000,"frame":"0","from":"x:50px;opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":3000,"frame":"999","to":"x:50px;opacity:0;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['right','right','right','right']" data-paddingtop="[0,0,0,0]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[0,0,0,0]" data-paddingleft="[0,0,0,0]"><a
                    href="https://www.omprakash.org/global/majik-water/donate"
                    class="btn btn-lg btn-light-outline btn-circle" style="padding: 20px 38px;">DONATE TO US</a></div>

              </div>

            </li>
            <!-- SLIDE  -->
            <li data-index="rs-3046" data-transition="fadetoleftfadefromright" data-slotamount="default"
              data-hideafterloop="0" data-hideslideonmobile="off" data-easein="default" data-easeout="default"
              data-masterspeed="default" data-rotate="0" data-saveperformance="off" data-title="" data-param1=""
              data-param2="" data-param3="" data-param4="" data-param5="" data-param6="" data-param7="" data-param8=""
              data-param9="" data-param10="" data-description="">
              <!-- MAIN IMAGE -->
              <img src="{{ asset('assets/web-new/assets/images/hero3.jpg')}}" alt="" class="rev-slidebg"
                data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-kenburns="off"
                data-duration="20000" data-ease="Linear.easeNone" data-scalestart="100" data-scaleend="200"
                data-offsetstart="0 0" data-offsetend="0 0" data-rotatestart="0" data-rotateend="0">

              <!-- LAYERS -->
              <!-- LAYER NR. 1 -->
              <div class="hero-text-wrap">
                <div class="tp-caption NotGeneric-Title tp-resizeme" id="slide-3045-layer-6"
                  data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['-120','-180','-180','-80']"
                  data-fontsize="['86','56','56','30']" data-lineheight="['100','76','76','40']" data-width="none"
                  data-height="none" data-whitespace="nowrap" data-type="text" data-responsive_offset="on"
                  data-frames='[{"delay":"+290","speed":2000,"frame":"0","from":"y:50px;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power4.easeOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['center','center','center','center']" data-paddingtop="[10,10,10,10]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[10,10,10,10]" data-paddingleft="[0,0,0,0]"
                  style="font-family: 'Montserrat', sans-serif;font-weight:700;">
                  The Situation <br />
                  <span class="text-bottom-line">
                  </span>
                </div>

                <!-- LAYER NR. 2 -->
                <div class="tp-caption NotGeneric-Title tp-resizeme" id="slide-3045-layer-7"
                  data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['60','60','0','0']"
                  data-fontsize="['22','22','22','12']" data-lineheight="['38','38','38','20']" data-width="none"
                  data-height="none" data-whitespace="nowrap" data-type="text" data-responsive_offset="on"
                  data-frames='[{"delay":"+490","speed":2000,"frame":"0","from":"y:50px;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power4.easeOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['center','center','center','center']" data-paddingtop="[10,10,10,10]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[10,10,10,10]" data-paddingleft="[0,0,0,0]"
                  style="font-family: 'Montserrat', sans-serif;font-weight:400;">1.8bn people living <br /> in water
                  scarcity by 2025 <br />
                  UN </div>

                <!-- LAYER NR. 4 -->
                <div class="tp-caption NotGeneric-SubTitle tp-resizeme" id="slide-3045-layer-4"
                  data-x="['center','center','center','center']" data-hoffset="['-100','0','-80','50']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['180','160','120','100']"
                  data-width="none" data-height="none" data-whitespace="nowrap" data-type="text"
                  data-responsive_offset="on"
                  data-frames='[{"delay":0,"speed":2500,"frame":"0","from":"x:-50px;opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":2500,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['left','left','left','left']" data-paddingtop="[0,0,0,0]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[0,0,0,0]" data-paddingleft="[0,0,0,0]"><a
                    class="btn btn-lg btn-light btn-circle" style="padding: 20px 38px;">Explore More</a></div>

                <!-- LAYER NR. 5 -->
                <div class="tp-caption NotGeneric-SubTitle tp-resizeme" id="slide-3045-layer-5"
                  data-x="['center','center','center','center']" data-hoffset="['100','0','100','40']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['180','160','120','180']"
                  data-width="none" data-height="none" data-whitespace="nowrap" data-type="text"
                  data-responsive_offset="on"
                  data-frames='[{"delay":0,"speed":3000,"frame":"0","from":"x:50px;opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":3000,"frame":"999","to":"x:50px;opacity:0;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['right','right','right','right']" data-paddingtop="[0,0,0,0]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[0,0,0,0]" data-paddingleft="[0,0,0,0]"><a
                    href="https://www.omprakash.org/global/majik-water/donate"
                    class="btn btn-lg btn-light-outline btn-circle" style="padding: 20px 38px;">DONATE TO US</a></div>

              </div>
            </li>
            <!-- SLIDE  -->
            <li data-index="rs-3047" data-transition="fadefrombottom" data-slotamount="default" data-hideafterloop="0"
              data-hideslideonmobile="off" data-easein="default" data-easeout="default" data-masterspeed="default"
              data-rotate="0" data-saveperformance="off" data-title="" data-param1="" data-param2="" data-param3=""
              data-param4="" data-param5="" data-param6="" data-param7="" data-param8="" data-param9="" data-param10=""
              data-description="">
              <!-- MAIN IMAGE -->
              <img src="{{ asset('assets/web-new/assets/images/hero2.jpg')}}" alt="" class="rev-slidebg"
                data-bgposition="center center" data-bgfit="cover" data-bgrepeat="no-repeat" data-kenburns="off"
                data-duration="20000" data-ease="Linear.easeNone" data-scalestart="100" data-scaleend="200"
                data-offsetstart="0 0" data-offsetend="0 0" data-rotatestart="0" data-rotateend="0">
              <!-- LAYERS -->
              <!-- LAYER NR. 1 -->
              <div class="hero-text-wrap">
                <div class="tp-caption NotGeneric-Title tp-resizeme" id="slide-3045-layer-10"
                  data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['-120','-180','-180','-80']"
                  data-fontsize="['86','56','56','30']" data-lineheight="['100','76','76','40']" data-width="none"
                  data-height="none" data-whitespace="nowrap" data-type="text" data-responsive_offset="on"
                  data-frames='[{"delay":"+290","speed":2000,"frame":"0","from":"y:50px;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power4.easeOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['center','center','center','center']" data-paddingtop="[10,10,10,10]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[10,10,10,10]" data-paddingleft="[0,0,0,0]"
                  style="font-family: 'Montserrat', sans-serif;font-weight:700;">
                </div>

                <!-- LAYER NR. 2 -->
                <div class="tp-caption NotGeneric-Title tp-resizeme" id="slide-3045-layer-11"
                  data-x="['center','center','center','center']" data-hoffset="['0','0','0','0']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['60','60','0','0']"
                  data-fontsize="['22','22','22','12']" data-lineheight="['38','38','38','20']" data-width="none"
                  data-height="none" data-whitespace="nowrap" data-type="text" data-responsive_offset="on"
                  data-frames='[{"delay":"+490","speed":2000,"frame":"0","from":"y:50px;opacity:0;fb:20px;","to":"o:1;fb:0;","ease":"Power4.easeOut"},{"delay":"wait","speed":300,"frame":"999","to":"opacity:0;fb:0;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['center','center','center','center']" data-paddingtop="[10,10,10,10]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[10,10,10,10]" data-paddingleft="[0,0,0,0]"
                  style="font-family: 'Montserrat', sans-serif;font-weight:400;">
                </div>

                <!-- LAYER NR. 4 -->
                <div class="tp-caption NotGeneric-SubTitle tp-resizeme" id="slide-3045-layer-4"
                  data-x="['center','center','center','center']" data-hoffset="['-100','0','-80','50']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['180','160','120','100']"
                  data-width="none" data-height="none" data-whitespace="nowrap" data-type="text"
                  data-responsive_offset="on"
                  data-frames='[{"delay":0,"speed":2500,"frame":"0","from":"x:-50px;opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":2500,"frame":"999","to":"auto:auto;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['left','left','left','left']" data-paddingtop="[0,0,0,0]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[0,0,0,0]" data-paddingleft="[0,0,0,0]"><a
                    class="btn btn-lg btn-light btn-circle" style="padding: 20px 38px;">Explore More</a></div>

                <!-- LAYER NR. 5 -->
                <div class="tp-caption NotGeneric-SubTitle tp-resizeme" id="slide-3045-layer-5"
                  data-x="['center','center','center','center']" data-hoffset="['100','0','100','40']"
                  data-y="['middle','middle','middle','middle']" data-voffset="['180','160','120','180']"
                  data-width="none" data-height="none" data-whitespace="nowrap" data-type="text"
                  data-responsive_offset="on"
                  data-frames='[{"delay":0,"speed":3000,"frame":"0","from":"x:50px;opacity:0;","to":"o:1;","ease":"Power3.easeInOut"},{"delay":"wait","speed":3000,"frame":"999","to":"x:50px;opacity:0;","ease":"Power3.easeInOut"}]'
                  data-textAlign="['right','right','right','right']" data-paddingtop="[0,0,0,0]"
                  data-paddingright="[0,0,0,0]" data-paddingbottom="[0,0,0,0]" data-paddingleft="[0,0,0,0]"><a
                    href="https://www.omprakash.org/global/majik-water/donate"
                    class="btn btn-lg btn-light-outline btn-circle" style="padding: 20px 38px;">DONATE TO US</a></div>

              </div>

            </li>
            <!-- SLIDE  -->

          </ul>
          <div class="tp-bannertimer" style="height: 3px; background-color: rgba(255, 255, 255, 0.25);"></div>
        </div>
      </div>
    </div>
    <!--== Hero Slider End ==-->
    <section class="white-bg" id="feature">
      <div class="container">
        <div class="row">
          <div class="col-md-6 col-sm-6">
            <img src="{{ asset('assets/web-new/assets/images/wwd.jpg')}}" alt="">
          </div>
          <div class="col-md-6 col-sm-6">
            <div class="section-title xs-mt-100">
              <!-- <h2 class="cardo-font default-color" data-backfont="Skills"></h2> -->
              <h3 class="mt-0 font-700" style="font-style: normal !important;">Our Impact</h3>
              <hr class="left-line default-bg">
              <h3>26 High volume deployments. <br>30 small scale deployments</h3>
              <p class="mt-20">
                Our primary environmental impact is in the reduction of freshwater usage that depletes finite
                groundwater reserves, while on climate change is through Greenhouse Gas (GHG) reduction by eliminating
                the emissions from use of firewood and charcoal in boiling water.</p>
            </div>
          </div>
        </div>
      </div>
    </section>

    <section id="feature" class="white-bg" style="margin-top: -150px;">
      <div class="container">
        <div class="row">
          <div class="col-md-8 col-sm-8 col-xs-12 centerize-col">
            <div class="section-title text-center">

              <h3 style="font-weight: 700;">Our Top Feature - Netflix Documentary</h3>
              <p class="mt-50 font-22px line-height-40">Narrated by Liam Neeson, interviewed by Matt Damon - our team
                was very proud to feature in this documentary about water innovations all over the world.
              </p>
            </div>
          </div>
        </div>
        <div class="row tabs-style-03 mt-50">
          <div class="col-md-6 col-sm-6 col-xs-12 xs-mb-50 transition-none">
            <div class="icon-tabs">
              <div class="row">
                <div class="col-md-4">
                  <ul class="nav nav-tabs text-center" role="tablist">
                    <li role="presentation" class="active"><a href="#design-2" role="tab" data-toggle="tab"><i
                          class="icon-browser"></i></a></li>
                    <li role="presentation"><a href="#development-2" role="tab" data-toggle="tab"><i
                          class="icon-global"></i></a></li>

                  </ul>
                </div>

                <div class="col-md-8">
                  <div class="tab-content text-center">
                    <div role="tabpanel" class="tab-pane fade in active" id="design-2">
                      <div class="text-left">
                        <h1 class="default-color font-800 mt-0">01</h1>
                        <h3 class="font-700">Documentary</h3>
                        <p>Watch the documentary to get insights on what we do.
                        </p>
                        <p class="mt-50"><a class="btn btn-md btn-color btn-animate btn-circle"
                            href="https://www.youtube.com/watch?v=FxZB9pRD2Bo&ab_channel=BraveBlueWorldFoundation"><span>Watch
                              on Youtube <i class="tr-icon icofont icofont-arrow-right"></i></span></a></p>
                      </div>
                    </div>
                    <div role="tabpanel" class="tab-pane fade" id="development-2">
                      <div class="text-left">
                        <h1 class="default-color font-800 mt-0">02</h1>
                        <h3 class="font-700">Water Scarcity by 2025 - UN</h3>
                        <p>People running out of water in Kenya and beyond.
                        </p>
                        <p class="mt-50"><a class="btn btn-md btn-color btn-animate btn-circle"
                            href="https://www.youtube.com/watch?v=FxZB9pRD2Bo&t=51s&ab_channel=BraveBlueWorldFoundation"><span>Watch
                              on YouTube <i class="tr-icon icofont icofont-arrow-right"></i></span></a></p>
                      </div>
                    </div>

                  </div>
                </div>

              </div>
            </div>
          </div>

          <div class="col-md-6 col-sm-6 col-xs-12">
            <img src="{{ asset('assets/web-new/assets/images/net.png')}}" alt="mockup" class="img-responsive" />
            <div class="video-box_overlay">
              <div class="center-layout">
                <div class="v-align-middle"> <a class="popup-youtube"
                    href="https://www.youtube.com/watch?v=FxZB9pRD2Bo">
                    <div class="play-button"><i class="tr-icon ion-android-arrow-dropright"></i></div>
                  </a> </div>
              </div>
            </div>
          </div>
          <br /> <br />
        </div>

      </div>
    </section>




    <section class="lg-section white-bg" id="about">
      <br />

      <div class="col-md-6 col-sm-6 bg-flex bg-flex-left">
        <!-- style="background-image: url(assets/images/into.jpg);" -->
        <img src="{{ asset('assets/web-new/assets/images/into.jpg')}}"
          style="height: auto; width: 80%; margin-left: 150px;" alt="">

      </div>
      <div class="container-fluid" style="margin-top: -90px !important;">
        <div class="col-md-5 col-sm-6 col-md-offset-6 col-sm-offset-6 pl-80 pr-70">
          <div class="section-title">
            <h3 class="default-color" style="font-weight: 700;">About Majik</h3>
            <hr class="left-line default-bg">

          </div>
          <p class="white-color">Majik Water Community-Centered Water Solutions </p>
          <p class="white-color">At Majik Water, we recognize that each community has its own unique water needs. We approach every community as a distinct case study, conducting in-depth needs analysis to understand their specific challenges and requirements. Our solution lies in providing decentralized water systems, a flexible and sustainable approach to meeting local water demands.

          </p>
          <p class="mt-30"><a class="btn btn-lg btn-color btn-circle" href="{{ route('about') }}">Read more</a></p>

        </div>
      </div>
    </section>
   
    <section class="white-bg" id="team">
      <div class="container">
        <div class="row">
          <div class="col-md-12 text-center">
            <div class="section-title text-center">
              <h3 style="font-weight: 700;">Meet The Team</h3>
            </div>
          </div>
        </div>

        <div class="row mt-50">
          @foreach($staff as $member)
          <!-- Team Member -->
          <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12 team-member-col">
              <div class="team-member">
                  <div class="team-thumb">
                      <img src="{{ asset($member->image_path) }}" alt="{{ $member->name }}" class="team-circle-img">
                      <div class="member-info text-center white-bg">
                          <h3>{{ $member->name }}</h3>
                          <span class="title">{{ $member->role }}</span>
                      </div>
                  </div>
              </div>
          </div>
          @endforeach
      </div>
    
        {{-- <div class="row mt-50">
          <!-- Team Member 1 -->
          <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12 team-member-col">
            <div class="team-member">
              <div class="team-thumb">
                <img src="{{ asset('assets/web-new/assets/images/beth.png')}}" alt="Anastasia Kaschenko" class="team-circle-img">
                <div class="member-info text-center white-bg">
                  <h3>Beth Koigi</h3>
                  <span class="title">CEO</span>
                
                </div>
              </div>
            </div>
          </div>
    
          <!-- Team Member 2 -->
          <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12 team-member-col">
            <div class="team-member">
              <div class="team-thumb">
                <img src="{{ asset('assets/web-new/assets/images/dif.png')}}" alt="Beth Koigi" class="team-circle-img">
                <div class="member-info text-center white-bg">
                  <h3>Samuel Njuguna</h3>
                  <span class="title">Lead Engineer</span>
                
                </div>
              </div>
            </div>
          </div>
    
          <!-- Team Member 3 -->
          <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12 team-member-col">
            <div class="team-member">
              <div class="team-thumb">
                <img src="{{ asset('assets/web-new/assets/images/dif.png')}}" alt="Clare Sewell" class="team-circle-img">
                <div class="member-info text-center white-bg">
                  <h3>Catherine Gathungu</h3>
                  <span class="title">Head of Operations</span>
                 
                </div>
              </div>
            </div>
          </div>
    
          <!-- Team Member 4 -->
          <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12 team-member-col">
            <div class="team-member">
              <div class="team-thumb">
                <img src="{{ asset('assets/web-new/assets/images/dif.png')}}" alt="Team Member" class="team-circle-img">
                <div class="member-info text-center white-bg">
                  <h3>Aminah Nzioka</h3>
                  <span class="title">Administration</span>
                  
                </div>
              </div>
            </div>
          </div>
    
          <!-- Team Member 5 -->
          <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12 team-member-col">
            <div class="team-member">
              <div class="team-thumb">
                <img src="{{ asset('assets/web-new/assets/images/dif.png')}}" alt="Team Member" class="team-circle-img">
                <div class="member-info text-center white-bg">
                  <h3>Dennis Muli</h3>
                  <span class="title"></span>
                 
                </div>
              </div>
            </div>
          </div>
    
          <!-- Team Member 6 -->
          <div class="col-lg-2 col-md-4 col-sm-6 col-xs-12 team-member-col">
            <div class="team-member">
              <div class="team-thumb">
                <img src="{{ asset('assets/web-new/assets/images/dif.png')}}" alt="Team Member" class="team-circle-img">
                <div class="member-info text-center white-bg">
                  <h3>Caroline Wamuyu</h3>
                  <span class="title">Community Mobilization</span>
                 
                </div>
              </div>
            </div>
          </div>
        </div> --}}
      </div>
    
      <style>
        /* Team Section Styles */
        .team-circle-img {
          width: 150px !important;
          height: 150px !important;
          border-radius: 50%;
          object-fit: cover;
          margin: 0 auto;
          display: block;
          border: 5px solid #f5f5f5;
        }
    
        .team-member {
          margin-bottom: 30px;
          text-align: center;
        }
    
        .member-info {
          /* padding: 20px; */
          height: 140px;
          margin-top: 90px;
          margin-bottom: -30px;
          border-radius: 5px;
          box-shadow: 0 5px 15px rgba(0, 0, 0, 0.1);
        }
    
        .member-info h3 {
          font-size: 14px;
          margin-bottom: 5px;
        }
    
        .member-info .title {
          color: #777;
          font-size: 12px;
          display: block;
          margin-bottom: 15px;
        }
    
        /* Responsive adjustments */
        @media (max-width: 767px) {
          .team-member-col {
            width: 100%;
            max-width: 300px;
            margin: 0 auto;
          }
          
          .team-circle-img {
            width: 120px !important;
            height: 120px !important;
          }
        }
    
        @media (min-width: 768px) and (max-width: 991px) {
          .team-member-col {
            width: 50%;
            float: left;
          }
        }
    
        @media (min-width: 992px) {
          .team-member-col {
            width: 16.66666667%; /* 6 items in a row */
            float: left;
          }
        }
      </style>
    </section>
    
   

    @if(!empty($blogs) && count($blogs) > 0)
    <section id="blog" style="margin-top: -110px;" class="white-bg">
      <div class="container">
        <div class="row">
          <div class="col-md-12 text-center">
            <div class="section-title text-center">
              <h3 style="font-weight: 700;">Our Top Stories Today</h3>
            </div>
          </div>
        </div>
        <div class="row mt-60 blog-style-01">
          @foreach ($blogs as $b)
          <div class="col-md-4 col-sm-4 col-xs-12">
            <div class="post">
              <div class="post-img">
                <img class="img-responsive" src="{{ asset($b->image) }}" alt="" />
                <div class="post-metas">
                  <div class="post-metas-center">
                    <p class="post-date">{{$b->posted_at}}</p>
                  </div>
                </div>
              </div>
              <div class="post-info all-padding-20">
                <h3><a href="{{ route('blogs', ['id' => $b->id]) }}">{{$b->title}}</a></h3>
                <p class="content-1">
                  {!! implode(' ', array_slice(explode(' ', strip_tags($b->content)), 0, 10)) .
                  (str_word_count($b->content) > 10? '...' : '') !!}
                </p>
              </div>
            </div>
          </div>
          @endforeach
        </div>
      </div>
    </section>
    @endif


  </div>
  </div>
  </section>
  <!--== Blog End ==-->
  <section id="portfolio" class="pb-0 pt-0" style=" background-color: white; margin-bottom: 20px;" class="white-bg">
    <div class="row">
      <div class="col-md-12 text-center">
        <div class="section-title text-center">
          <h3 style="font-weight: 700;">Partners</h3>
        </div>
      </div>
    </div>
    <div class="container-fluid remove-padding">
      <!-- First Row of Partners -->
      <div class="row mt-30 partner-row">
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/1.png')}}"
              alt="The Wise Fund" />
            <div class="partner-name">The Wise Fund</div>
          </div>
        </div>
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/2.png')}}"
              alt="Habitat for Humanity" />
            <div class="partner-name">Habitat for Humanity</div>
          </div>
        </div>
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/3.png')}}"
              alt="Kenya Climate Innovation Centre" />
            <div class="partner-name">Kenya Climate Innovation Centre</div>
          </div>
        </div>
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/4.png')}}"
              alt="Just Peoples" />
            <div class="partner-name">Just Peoples</div>
          </div>
        </div>
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/5.png')}}"
              alt="Royal Academy of Engineering" />
            <div class="partner-name">Royal Academy of Engineering</div>
          </div>
        </div>
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/6.png')}}"
              alt="Tungana" />
            <div class="partner-name">Tungana</div>
          </div>
        </div>
      </div>

      <!-- Second Row of Partners -->
      <div class="row mt-30 partner-row">
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/p1.png')}}"
              alt="Shelter Tech" />
            <div class="partner-name">Shelter Tech</div>
          </div>
        </div>
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/p2.png')}}"
              alt="Norwegian Refugee Council" />
            <div class="partner-name">Norwegian Refugee Council</div>
          </div>
        </div>
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/p3.png')}}"
              alt="Renewvia Energy" />
            <div class="partner-name">Renewvia Energy</div>
          </div>
        </div>
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/p4.png')}}"
              alt=">Gift of the Givers Foundation" />
            <div class="partner-name">Gift of the Givers Foundation</div>
          </div>
        </div>
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/p5.png')}}"
              alt="Partner 11" />
            <div class="partner-name">Partner 11</div>
          </div>
        </div>
        <div class="col-md-2 col-sm-4 col-xs-6">
          <div class="client-logo">
            <img class="img-responsive partner-logo" src="{{ asset('assets/web-new/assets/images/pp1.png')}}"
              alt="Partner 12" />
            <div class="partner-name">Microsoft</div>
          </div>
        </div>
      </div>
    </div>

    <style>
      /* Partners Section Styles */
      .partner-row {
        display: flex;
        flex-wrap: wrap;
        justify-content: center;
        margin-bottom: 30px;
      }

      .client-logo {
        text-align: center;
        padding: 20px;
        margin-bottom: 20px;
        transition: all 0.3s ease;
      }

      .partner-logo {
        max-width: 100%;
        height: auto;
        /* max-height: 90px; */
        /* filter: grayscale(100%); */
        /* opacity: 0.7; */
        transition: all 0.3s ease;
      }

      .client-logo:hover .partner-logo {
        /* filter: grayscale(0%); */
        /* opacity: 1; */
        transform: scale(1.05);
      }

      .partner-name {
        margin-top: 15px;
        font-size: 14px;
        /* color: #555; */
        font-weight: 500;
        opacity: 0;
        transition: all 0.3s ease;
      }

      .client-logo:hover .partner-name {
        /* opacity: 1; */
      }

      @media (max-width: 767px) {
        .client-logo {
          padding: 10px;
        }

        .partner-logo {
          max-height: 60px;
        }

        .partner-name {
          font-size: 12px;
          margin-top: 8px;
        }
      }
    </style>
  </section>

  <!--== Contact Start ==-->
  <div class="white-bg pt-0 pb-0 transition-none cover-bg" id="contact">
    <div class="col-md-6 col-sm-6 bg-flex bg-flex-left">
      <div class="bg-flex-holder bg-flex-cover">
        <!-- Map Container -->
        <div class="mapouter">
          <div class="gmap_canvas">
            {{-- <iframe class="gmap_iframe" width="100%" frameborder="0" scrolling="no" marginheight="0" marginwidth="0"
              src="https://maps.google.com/maps?width=780&amp;height=500&amp;hl=en&amp;q=Kenya Climate Innovation Centre  Industrial Area, Nairobi, Kenya&amp;t=&amp;z=14&amp;ie=UTF8&amp;iwloc=B&amp;output=embed">
            </iframe> --}}
            <iframe class="gmap_iframe" width="100%" frameborder="0" scrolling="no" marginheight="0" marginwidth="0" src="https://maps.google.com/maps?width=780&amp;height=500&amp;hl=en&amp;q=Kabati,  Wempa, Off Thika Road&amp;t=&amp;z=10&amp;ie=UTF8&amp;iwloc=B&amp;output=embed"></iframe>


          </div>
        </div>
        <style>
          .mapouter {
            position: relative;
            text-align: right;
            width: 100%;
            height: 100%;
          }

          .gmap_canvas {
            overflow: hidden;
            background: none !important;
            width: 100%;
            height: 100%;
          }

          .gmap_iframe {
            width: 100%;
            height: 100%;
          }

          .bg-flex-holder {
            display: flex;
            justify-content: center;
            align-items: center;
            height: 100%;
            /* Ensures the div stretches to the height of its container */
          }
        </style>
      </div>
    </div>

    <div class="container">
      <div class="col-md-5 col-sm-6 col-md-offset-7 col-sm-offset-6 pt-70 pb-70 xs-pt-20 xs-pb-80">

        <form name="contact-form" id="contact-form" action="php/contact.php" method="POST"
          class="contact-form-style-01">
          <div class="messages"></div>
          <div class="row">
            <div class="col-md-6 col-sm-6">
              <div class="form-group">
                <label for="name">Name*</label>
                <input type="text" name="name" class="md-input" id="name" required data-error="Your Name is Required">
              </div>
            </div>
            <div class="col-md-6 col-sm-6">
              <div class="form-group">
                <label for="email">Email*</label>
                <input type="email" name="email" class="md-input" id="email" required
                  data-error="Please Enter Valid Email">
              </div>
            </div>
            <div class="col-md-12 col-sm-12">
              <div class="form-group">
                <label for="subject">Subject</label>
                <input type="text" name="subject" class="md-input" id="subject">
              </div>
            </div>
            <div class="col-md-12 col-sm-12">
              <div class="form-group">
                <label for="message">Project Details</label>
                <textarea name="message" class="md-textarea" id="message" rows="7" required
                  data-error="Please, Leave us a message"></textarea>
              </div>
            </div>
            <div class="col-md-12 col-sm-12">
              <div class="text-left mt-20">
                <button type="submit" name="submit" class="btn btn-lg btn-color btn-circle remove-margin">Send Message
                </button>
              </div>
            </div>
          </div>
        </form>
      </div>
    </div>
  </div>
  <!--== Contact End ==-->

  <!--== Footer Start ==-->
  @include('web.layouts.footer')

  <!--== Footer End ==-->

  <!--== Go to Top  ==-->
  <a href="javascript:" id="return-to-top"><i class="icofont icofont-arrow-up"></i></a>
  <!--== Go to Top End ==-->

  </div>
  <!--== Wrapper End ==-->
  @include('web.layouts.js')


</body>

</html>