<!DOCTYPE html>
<html lang="en">
  @include('web.layouts.head')

<body>

<!--== Loader Start ==-->
<div id="loader-overlay">
  <div class="loader">
    <img src="{{ asset('assets/web-new/assets/images/loader.svg')}}" width="80" alt="" style="fill: blue;">
  </div>
</div>
<!--== Loader End ==-->

<!--== Wrapper Start ==-->
<div class="wrapper">
    @include('web.header.nav')

    <!--== Header End ==-->

    <!-- Gallery Hero Section -->
    <section class="gallery-hero" style="background: url('{{ asset('assets/web-new/assets/images/gallery-hero.jpg')}}') no-repeat center center; background-size: cover; height: 60vh; position: relative;">
      <div class="hero-overlay">
        <div class="container">
          <div class="row">
            <div class="col-md-12 text-center">
              <h1 class="text-white font-700" style="font-size: 4rem; margin-top: 15vh;">Our Gallery</h1>
              <p class="text-white lead">Capturing our journey in images</p>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!-- Gallery Section -->
    <section class="pt-100 pb-100 gray-bg" id="gallery">
      <div class="container">
        <div class="row">
          <div class="col-md-12">
            <div class="section-title text-center">
              <h3 class="font-700">Featured Images</h3>
              <hr class="center-line default-bg">
            </div>
          </div>
        </div>

        <div class="row gallery-container">
          <!-- Gallery Item 1 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal.jpg')}}" alt="Gallery Image 1" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>

          <!-- Gallery Item 2 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal1.jpg')}}" alt="Gallery Image 2" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>

          <!-- Gallery Item 3 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal2.jpg')}}" alt="Gallery Image 3" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>

          <!-- Gallery Item 4 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal3.jpg')}}" alt="Gallery Image 4" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>

          <!-- Gallery Item 5 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal4.jpg')}}" alt="Gallery Image 5" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>

          <!-- Gallery Item 6 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal5.jpg')}}" alt="Gallery Image 6" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>

          <!-- Gallery Item 7 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal6.jpg')}}" alt="Gallery Image 7" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>

          <!-- Gallery Item 8 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal7.jpg')}}" alt="Gallery Image 8" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>

          <!-- Gallery Item 9 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal8.jpg')}}" alt="Gallery Image 9" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>

          <!-- Gallery Item 10 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal9.jpg')}}" alt="Gallery Image 10" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>

          <!-- Gallery Item 11 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal.jpg')}}" alt="Gallery Image 11" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>

          <!-- Gallery Item 12 -->
          <div class="col-lg-3 col-md-4 col-sm-6 gallery-item">
            <div class="gallery-card">
              <img src="{{ asset('assets/web-new/assets/images/gal.jpg')}}" alt="Gallery Image 12" class="img-fluid">
              <div class="gallery-overlay">
                <div class="gallery-caption">
                  <h4>Majik Water gallery</h4>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </section>

    <!--== Footer Start ==-->
    @include('web.layouts.footer')
    <!--== Footer End ==-->

    <!--== Go to Top  ==-->
    <a href="javascript:" id="return-to-top"><i class="icofont icofont-arrow-up"></i></a>
    <!--== Go to Top End ==-->

</div>
<!--== Wrapper End ==-->

@include('web.layouts.js')

<style>
  /* Gallery Hero Section */
  .gallery-hero {
    position: relative;
  }
  
  .hero-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background-color: rgba(0, 0, 0, 0.5);
    display: flex;
    align-items: center;
    justify-content: center;
  }

  /* Gallery Styles */
  .gallery-container {
    margin-top: 50px;
  }
  
  .gallery-item {
    margin-bottom: 30px;
    padding: 0 15px;
  }
  h4{
    color: #fff
  }
  
  .gallery-card {
    position: relative;
    overflow: hidden;
    border-radius: 8px;
    box-shadow: 0 5px 15px rgba(0,0,0,0.1);
    transition: all 0.5s ease;
    height: 250px;
  }
  
  .gallery-card img {
    width: 100%;
    height: 100%;
    object-fit: cover;
    transition: all 0.5s ease;
  }
  
  .gallery-overlay {
    position: absolute;
    top: 0;
    left: 0;
    width: 100%;
    height: 100%;
    background: #0f6979;
    opacity: 0;
    display: flex;
    align-items: center;
    justify-content: center;
    transition: all 0.5s ease;
    transform: scale(0.8);
  }
  
  .gallery-caption {
    text-align: center;
    padding: 20px;
    color: #fff;
    transform: translateY(20px);
    transition: all 0.5s ease;
  }
  
  .gallery-caption h4 {
    font-weight: 700;
    margin-bottom: 10px;
    font-size: 18px;
  }
  
  .gallery-caption p {
    font-size: 14px;
  }
  
  /* Hover Effects */
  .gallery-card:hover {
    transform: translateY(-10px);
    box-shadow: 0 15px 30px rgba(0,0,0,0.2);
  }
  
  .gallery-card:hover img {
    transform: scale(1.1);
  }
  
  .gallery-card:hover .gallery-overlay {
    opacity: 1;
    transform: scale(1);
  }
  
  .gallery-card:hover .gallery-caption {
    transform: translateY(0);
  }
  
  /* Flip Effect on Hover */
  .gallery-item:nth-child(3n) .gallery-card:hover {
    transform: perspective(1000px) rotateY(180deg) translateY(-10px);
  }
  
  .gallery-item:nth-child(3n) .gallery-card:hover img {
    transform: perspective(1000px) rotateY(180deg) scale(1.1);
    opacity: 0;
  }
  
  .gallery-item:nth-child(3n) .gallery-overlay {
    transform: perspective(1000px) rotateY(180deg) scale(0.8);
    backface-visibility: hidden;
  }
  
  .gallery-item:nth-child(3n) .gallery-card:hover .gallery-overlay {
    transform: perspective(1000px) rotateY(0deg) scale(1);
  }
  
  /* Zoom Effect on Hover */
  .gallery-item:nth-child(4n) .gallery-card:hover {
    transform: scale(1.05);
    z-index: 10;
  }
  
  .gallery-item:nth-child(4n) .gallery-card:hover img {
    transform: scale(1.2);
  }
  
  /* Responsive Adjustments */
  @media (max-width: 992px) {
    .gallery-item {
      flex: 0 0 33.333%;
      max-width: 33.333%;
    }
  }
  
  @media (max-width: 768px) {
    .gallery-item {
      flex: 0 0 50%;
      max-width: 50%;
    }
    
    .gallery-hero h1 {
      font-size: 3rem !important;
    }
  }
  
  @media (max-width: 576px) {
    .gallery-item {
      flex: 0 0 100%;
      max-width: 100%;
    }
    
    .gallery-hero h1 {
      font-size: 2rem !important;
    }
  }
</style>

</body>
</html>