<?php $page="productlist"; ?>
@extends('layout.mainlayout')

@section('content')
<div class="page-wrapper">
    <div class="content">
        @component('components.pageheader')
            @slot('title') Orders List @endslot
            @slot('title_1') Manage your orders @endslot
        @endcomponent
        <div class="card">
            <div class="card-body">
                <div class="table-top">
                    <div class="search-set">
                        <div class="search-path">
                            <a class="btn btn-filter" id="filter_search">
                                <img src="{{ URL::asset('/assets/img/icons/filter.svg') }}" alt="img">
                                <span><img src="{{ URL::asset('/assets/img/icons/closes.svg') }}" alt="img"></span>
                            </a>
                        </div>
                        <div class="search-input">
                            <a class="btn btn-searchset"><img src="{{ URL::asset('/assets/img/icons/search-white.svg') }}" alt="img"></a>
                        </div>
                    </div>
                    <div class="wordset">
                        <ul>
                            <li>
                                <a data-bs-toggle="tooltip" data-bs-placement="top" title="pdf"><img src="{{ URL::asset('/assets/img/icons/pdf.svg') }}" alt="img"></a>
                            </li>
                            <li>
                                <a data-bs-toggle="tooltip" data-bs-placement="top" title="excel"><img src="{{ URL::asset('/assets/img/icons/excel.svg') }}" alt="img"></a>
                            </li>
                            <li>
                                <a data-bs-toggle="tooltip" data-bs-placement="top" title="print"><img src="{{ URL::asset('/assets/img/icons/printer.svg') }}" alt="img"></a>
                            </li>
                        </ul>
                    </div>
                </div>

                <!-- /Filter -->
                <div class="table-responsive">
                    <table class="table datanew">
                        <thead>
                            <tr>
                                <th>
                                    <label class="checkboxs">
                                        <input type="checkbox" id="select-all">
                                        <span class="checkmarks"></span>
                                    </label>
                                </th>
                                <th>Customer Names</th>
                                <th>Product ID</th>
                                <th>Price</th>
                                <th>Cust Address</th>
                                <th>Cust Phone</th>
                                <th>Cust Town</th>
                                <th>Action</th>
                            </tr>
                        </thead>
                        <tbody>

                            @foreach ($orders as $product)
                                <tr>
                                    <td>
                                        <label class="checkboxs">
                                            <input type="checkbox" name="product_ids[]" value="{{ $product['id'] }}">
                                            <span class="checkmarks"></span>
                                        </label>
                                    </td>
                                    <td>{{ $product['names'] }}</td>
                                    <td>{{ $product['product_id'] }}</td>
                                    <td>{{ number_format($product['product_price'], 2) }}</td>
                                    <td>{{ $product['house_number_street_name'] }}</td>
                                    <td>{{ $product['phone'] }}</td>
                                    <td>{{ $product['town_city'] }}</td>

                                    <td>
                                        <a href="#" class="btn btn-sm btn-primary">Edit</a>
                                        <form action="#" method="POST" style="display: inline-block;">
                                            @csrf
                                            @method('DELETE')
                                            <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure you want to delete this product?')">Delete</button>
                                        </form>
                                    </td>
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</div>
@endsection
