<?php $page="addproduct"; ?>
@extends('layout.mainlayout')
@section('content')
<div class="page-wrapper">
    <div class="content">
        @component('components.pageheader')
            @slot('title') Blog Add @endslot
            @slot('title_1') Create new blog post @endslot
        @endcomponent
        <!-- /add -->
        <div class="card">
            <div class="card-body">
                <form action="{{ url('submit-blog') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <div class="col-12">
                            <div class="form-group">
                                <label>Title of the post</label>
                                <input type="text" name="title" required>
                            </div>
                        </div>

                        <div class="col-lg-12">
                            <div class="form-group">
                                <label>Description</label>
                                <textarea id="product_desc" name="product_desc"></textarea>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <div class="form-group">
                                <label>Blog Image (250px by 250px)</label>
                                <div class="image-upload">
                                    <input type="file" name="image" required>
                                    <div class="image-uploads">
                                        <img src="{{ URL::asset('/assets/img/icons/upload.svg') }}" alt="img">
                                        <h4>Drag and drop a file to upload</h4>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12">
                            <button type="submit" class="btn btn-submit me-2">Submit</button>
                            <a href="{{ url('majik-blogs') }}" class="btn btn-cancel">Cancel</a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
        <!-- /add -->
    </div>
</div>

<script src="https://cdn.tiny.cloud/1/ay66puca8ccee8xg0pc0s6sbh26a5b6eru535ewz4hys3jlm/tinymce/6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
    tinymce.init({
        selector: '#product_desc',
        plugins: 'lists link image table',
        toolbar: 'undo redo | bold italic underline | bullist numlist outdent indent | link image table',
        height: 200,
        menubar: false
    });
</script>
@endsection
