<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Overview</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css">
    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.9.3/dist/leaflet.css" />
    <link href="https://cdn.quilljs.com/1.3.6/quill.snow.css" rel="stylesheet">

    <script src="https://cdn.jsdelivr.net/npm/chart.js"></script>

    <!-- Include Quill library -->
    <script src="https://cdn.quilljs.com/1.3.6/quill.js"></script>
    <style>
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }

        body {
            background-color: #f8f9fa;
            color: #333;
            padding: 20px;
        }

        .product-image {
            height: 50px;
        }

        .dashboard {
            display: grid;
            grid-template-columns: 200px 1fr;
            gap: 20px;
            max-width: 1200px;
            margin: 0 auto;
        }

        .sidebar {
            background-color: #fff;
            border-radius: 8px;
            padding: 20px 15px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            height: fit-content;
        }

        .sidebar h2 {
            font-size: 16px;
            margin-bottom: 20px;
            color: #444;
            font-weight: 600;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
            display: flex;
            align-items: center;
        }

        .sidebar h2 i {
            margin-right: 10px;
            color: #1a73e8;
        }

        .sidebar ul {
            list-style: none;
        }

        .sidebar li {
            margin-bottom: 12px;
            padding: 8px 10px;
            border-radius: 5px;
            cursor: pointer;
            transition: all 0.2s;
            font-size: 14px;
            display: flex;
            align-items: center;
        }

        .sidebar li i {
            margin-right: 10px;
            width: 20px;
            text-align: center;
            font-size: 14px;
            color: #666;
        }

        .sidebar li:hover {
            background-color: #f0f2f5;
        }

        .sidebar li.active {
            background-color: #e6f0ff;
            color: #1a73e8;
            font-weight: 500;
        }

        .sidebar li.active i {
            color: #1a73e8;
        }

        .main-content {
            display: grid;
            grid-template-columns: repeat(3, 1fr);
            gap: 15px;
        }

        .card {
            background-color: #fff;
            border-radius: 8px;
            padding: 15px;
            box-shadow: 0 1px 3px rgba(0, 0, 0, 0.1);
            position: relative;
        }

        .card h3 {
            font-size: 14px;
            margin-bottom: 12px;
            color: #555;
            font-weight: 600;
            display: flex;
            align-items: center;
        }

        .card h3 i {
            margin-right: 8px;
            color: #1a73e8;
            font-size: 16px;
        }

        .card-large {
            grid-column: span 2;
        }

        .card-full {
            grid-column: span 3;
        }

        .stat-value {
            font-size: 24px;
            font-weight: 600;
            color: #1a73e8;
            margin: 8px 0;
            display: flex;
            align-items: center;
        }

        .stat-icon {
            margin-right: 8px;
            font-size: 20px;
        }

        .stat-label {
            font-size: 12px;
            color: #777;
        }

        .divider {
            height: 1px;
            background-color: #eee;
            margin: 12px 0;
        }

        .data-row {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            font-size: 13px;
            align-items: center;
        }

        .data-label {
            color: #666;
            display: flex;
            align-items: center;
        }

        .data-label i {
            margin-right: 6px;
            font-size: 12px;
        }

        .data-value {
            color: #333;
            font-weight: 500;
        }

        .graph-placeholder {
            height: 120px;
            background-color: #f8f9fa;
            border-radius: 4px;
            margin-top: 12px;
            display: flex;
            align-items: flex-end;
            padding: 8px;
            position: relative;
            overflow: hidden;
        }

        .graph-placeholder::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            right: 0;
            height: 1px;
            background-color: #eee;
        }

        .graph-bar {
            flex-grow: 1;
            background-color: #1a73e8;
            margin: 0 2px;
            border-radius: 3px 3px 0 0;
            position: relative;
            transition: height 0.5s ease;
        }

        .graph-bar.humidity {
            background-color: #34a853;
        }

        .graph-bar::after {
            content: attr(data-value);
            position: absolute;
            top: -20px;
            left: 50%;
            transform: translateX(-50%);
            font-size: 10px;
            color: #555;
            background-color: #fff;
            padding: 0 3px;
            border-radius: 3px;
            box-shadow: 0 1px 2px rgba(0, 0, 0, 0.1);
        }

        .location-item {
            display: flex;
            justify-content: space-between;
            margin-bottom: 8px;
            padding-bottom: 8px;
            border-bottom: 1px dashed #eee;
            font-size: 13px;
        }

        .location-name {
            font-weight: 500;
            color: #444;
            display: flex;
            align-items: center;
        }

        .location-icon {
            width: 24px;
            height: 24px;
            border-radius: 50%;
            background-color: #e6f0ff;
            color: #0f6979;
            display: flex;
            align-items: center;
            justify-content: center;
            margin-right: 8px;
            font-size: 12px;
        }

        .location-stats {
            text-align: right;
        }

        .trend-up {
            color: #34a853;
            font-size: 11px;
            display: flex;
            align-items: center;
            justify-content: flex-end;
        }

        .trend-up i {
            margin-right: 2px;
            font-size: 10px;
        }

        .more-link {
            text-align: right;
            margin-top: 12px;
        }

        .more-link a {
            color: #1a73e8;
            text-decoration: none;
            font-weight: 500;
            font-size: 13px;
            display: inline-flex;
            align-items: center;
        }

        .more-link a i {
            margin-left: 5px;
            font-size: 12px;
        }

        .inline-stat {
            display: inline-block;
            margin-left: 5px;
            color: #1a73e8;
            font-weight: 600;
        }

        .device-status {
            display: flex;
            align-items: center;
            margin-bottom: 8px;
        }

        .status-indicator {
            width: 10px;
            height: 10px;
            border-radius: 50%;
            margin-right: 6px;
        }

        .status-online {
            background-color: #34a853;
        }

        .status-offline {
            background-color: #ea4335;
        }

        .map-container {
            height: 100%;
            width: 100%;
            border-radius: 4px;
            margin-top: 10px;
            overflow: hidden;
        }

        #devicesMap {
            height: 100%;
            width: 100%;
            min-height: 250px;
        }

        .card-with-map {
            min-height: 300px;
        }

        .chart-container {
            position: relative;
            height: 200px;
            width: 100%;
            margin-top: 15px;
        }

        /* Modal Styles */
        .modal {
            display: none;
            position: fixed;
            z-index: 1000;
            left: 0;
            top: 0;
            width: 100%;
            height: 100%;
            background-color: rgba(0, 0, 0, 0.5);
            overflow: auto;
        }

        .modal-content {
            background-color: #fff;
            margin: 5% auto;
            padding: 20px;
            border-radius: 8px;
            box-shadow: 0 4px 8px rgba(0, 0, 0, 0.1);
            width: 80%;
            max-width: 900px;
            max-height: 80vh;
            overflow-y: auto;
        }

        .modal-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-bottom: 20px;
            padding-bottom: 10px;
            border-bottom: 1px solid #eee;
        }

        .modal-title {
            font-size: 18px;
            font-weight: 600;
            color: #333;
        }

        .close {
            color: #aaa;
            font-size: 24px;
            font-weight: bold;
            cursor: pointer;
        }

        .close:hover {
            color: #333;
        }

        .users-table {
            width: 100%;
            border-collapse: collapse;
            margin-top: 15px;
        }

        .users-table th,
        .users-table td {
            padding: 12px 15px;
            text-align: left;
            border-bottom: 1px solid #eee;
        }

        .users-table th {
            background-color: #f8f9fa;
            font-weight: 600;
            color: #555;
        }

        .users-table tr:hover {
            background-color: #f5f7fa;
        }

        .action-btn {
            padding: 6px 12px;
            border-radius: 4px;
            border: none;
            cursor: pointer;
            font-size: 12px;
            margin-right: 5px;
        }

        .edit-btn {
            background-color: #1a73e8;
            color: white;
        }

        .delete-btn {
            background-color: #ea4335;
            color: white;
        }

        .modal-footer {
            display: flex;
            justify-content: flex-end;
            margin-top: 20px;
            padding-top: 15px;
            border-top: 1px solid #eee;
        }

        .btn {
            padding: 8px 16px;
            border-radius: 4px;
            border: none;
            cursor: pointer;
            font-size: 14px;
            margin-left: 10px;
        }

        .btn-primary {
            background-color: #1a73e8;
            color: white;
        }

        .btn-secondary {
            background-color: #6c757d;
            color: white;
        }

        .form-group {
            margin-bottom: 15px;
        }

        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 500;
            color: #555;
        }

        .form-control {
            width: 100%;
            padding: 8px 12px;
            border: 1px solid #ddd;
            border-radius: 4px;
            font-size: 14px;
        }

        .form-control:focus {
            border-color: #1a73e8;
            outline: none;
            box-shadow: 0 0 0 2px rgba(26, 115, 232, 0.2);
        }

        @media (max-width: 1000px) {
            .dashboard {
                grid-template-columns: 1fr;
            }

            .main-content {
                grid-template-columns: repeat(2, 1fr);
            }

            .card-large {
                grid-column: span 1;
            }

            .modal-content {
                width: 90%;
                margin: 10% auto;
            }
        }

        @media (max-width: 600px) {
            .main-content {
                grid-template-columns: 1fr;
            }

            .modal-content {
                width: 95%;
                margin: 15% auto;
            }

            .users-table th,
            .users-table td {
                padding: 8px 10px;
                font-size: 12px;
            }
        }
    </style>
</head>

<body>
    <div class="dashboard">
        <div class="sidebar">
            <h2><i class="fas fa-chart-pie"></i> Overview</h2>
            <ul>
                <li class="active"><i class="fas fa-home"></i> Home</li>
                <li data-modal="dataVisualisationModal"><i class="fas fa-chart-line"></i> Data Visualisation</li>
                <li data-modal="devicesModal"><i class="fas fa-microchip"></i> Devices & Sensors</li>
                <li data-modal="alertsModal"><i class="fas fa-bell"></i> Alerts</li>
                <li data-modal="userManagementModal"><i class="fas fa-users"></i> User Management</li>
                <li data-modal="teamMembersModal"><i class="fas fa-users-cog"></i> Team Members</li>
                <li data-modal="productsModal"><i class="fas fa-shopping-cart"></i> Products</li>
                <li data-modal="ordersModal"><i class="fas fa-file-export"></i> Orders</li>
                <li data-modal="newsModal"><i class="fas fa-globe"></i>News & Blogs</li>
                <li data-modal="clientsModal"><i class="fas fa-money-bill"></i>Clients </li>
                <li data-modal="emailModal"><i class="fas fa-envelope"></i>Subscriptions Mail </li>
                <li data-modal="settingsModal"><i class="fas fa-cog"></i> Settings</li>
                <li id="logoutBtn"><i class="fas fa-sign-out"></i> Log out</li>

            </ul>
        </div>

        <div class="main-content">
            <div class="card">
                <h3><i class="fas fa-microchip"></i> Total No. of Devices</h3>
                <div class="stat-value"><i class="fas fa-server stat-icon"></i> 7</div>
                <div class="stat-label">Active Devices</div>
                <div class="device-status">
                    <span class="status-indicator status-online"></span>
                    <span class="data-label">5 Online</span>
                </div>
                <div class="device-status">
                    <span class="status-indicator status-offline"></span>
                    <span class="data-label">2 Offline</span>
                </div>
            </div>

            <div class="card">
                <h3><i class="fas fa-map-marker-alt"></i> Locations Deployed</h3>
                <div class="stat-value"><i class="fas fa-layer-group stat-icon"></i> 3</div>
                <div class="data-row">
                    <span class="data-label"><i class="far fa-calendar-alt"></i> Box</span>
                    <span class="data-value">Weeks Months</span>
                </div>
                <div class="divider"></div>
                <div class="data-row">
                    <span class="data-label"><i class="far fa-clock"></i>Between Oct. 2024 - April, 2025</span>
                </div>
            </div>

            <div class="card card-with-map">
                <h3><i class="fas fa-signal"></i> Devices Location Map</h3>
                <div class="map-container">
                    <div id="devicesMap"></div>
                </div>
            </div>

            <div class="card card-large">
                <h3><i class="fas fa-thermometer-half"></i> Temperature and Humidity Graph</h3>
                <div class="data-row">
                    <span class="data-label"><i class="fas fa-fire"></i> Temperature</span>
                    <span class="data-value"><i class="fas fa-tint"></i> Humidity</span>
                </div>
                <div class="graph-placeholder">
                    <div class="graph-bar" style="height: 80%;" data-value="80°"></div>
                    <div class="graph-bar" style="height: 70%;" data-value="70°"></div>
                    <div class="graph-bar" style="height: 60%;" data-value="60°"></div>
                    <div class="graph-bar" style="height: 50%;" data-value="50°"></div>
                    <div class="graph-bar" style="height: 40%;" data-value="40°"></div>
                    <div class="graph-bar humidity" style="height: 65%;" data-value="65%"></div>
                    <div class="graph-bar humidity" style="height: 55%;" data-value="55%"></div>
                    <div class="graph-bar humidity" style="height: 45%;" data-value="45%"></div>
                    <div class="graph-bar humidity" style="height: 35%;" data-value="35%"></div>
                </div>
            </div>

            <div class="card">
                <div class="data-row">
                    <span class="data-label"><i class="fas fa-chart-pie"></i> Devices Distribution</span>
                </div>
                <div class="chart-container">
                    <canvas id="devicesPieChart"></canvas>
                </div>
            </div>

            <div class="card card-full">
                <h3><i class="fas fa-map-marked-alt"></i> Latitude and Longitude Details</h3>
                <div class="location-item">
                    <div class="location-name">
                        <span class="location-icon"><i class="fas fa-map-marker-alt"></i></span>
                        Marsabit
                    </div>
                    <div class="location-stats">
                        <div>Latitude: 2.3333° N</div>
                        <div>Longitude: 37.9167° E</div>
                    </div>
                </div>
                <div class="location-item">
                    <div class="location-name">
                        <span class="location-icon"><i class="fas fa-map-marker-alt"></i></span>
                        Wajir
                    </div>
                    <div class="location-stats">
                        <div>Latitude: 1.7500° N</div>
                        <div>Longitude: 40.0833° E</div>
                    </div>
                </div>
                <div class="location-item">
                    <div class="location-name">
                        <span class="location-icon"><i class="fas fa-map-marker-alt"></i></span>
                        Moyale
                    </div>
                    <div class="location-stats">
                        <div>Latitude: 3.5333° N</div>
                        <div>Longitude: 39.0500° E</div>
                    </div>
                </div>
            </div>

            <div class="card card-large">
                <h3><i class="fas fa-database"></i> Data Transmitted</h3>
                <div class="data-row">
                    <span class="data-label"><i class="fas fa-fire"></i> Temperature</span>
                    <span class="data-value"><i class="fas fa-tint"></i> Humidity</span>
                </div>
                <div class="graph-placeholder">
                    <div class="graph-bar" style="height: 80%;" data-value="80°"></div>
                    <div class="graph-bar" style="height: 75%;" data-value="75°"></div>
                    <div class="graph-bar" style="height: 100%;" data-value="100°"></div>
                    <div class="graph-bar humidity" style="height: 25%;" data-value="25%"></div>
                    <div class="graph-bar humidity" style="height: 40%;" data-value="40%"></div>
                </div>
            </div>

            <div class="card">
                <h3><i class="far fa-calendar-alt"></i> April 2024</h3>
                <div class="data-row">
                    <span class="data-label"><i class="fas fa-dollar-sign"></i> 20</span>
                    <span class="data-value"><i class="fas fa-tint"></i> Humidity</span>
                </div>
                <div class="data-row">
                    <span class="data-label"><i class="fas fa-dollar-sign"></i> 25</span>
                    <span class="data-value"><i class="fas fa-fire"></i> Temperature</span>
                </div>
                <div class="map-container" style="height: 60px; margin-top: 15px;">
                    <div id="trendsMap" style="height: 100%;"></div>
                </div>
            </div>

            <div class="card card-full more-link">
                <a href="#">IoT Dashboard <i class="fas fa-chevron-right"></i></a>
            </div>
        </div>
    </div>

    <!-- Home Modal -->
    <div id="homeModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-home"></i> Home Dashboard</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <p>Welcome to your IoT Dashboard home page. This is the central hub for all your device monitoring and
                    data visualization needs.</p>
                <div class="divider"></div>
                <h4>Quick Stats</h4>
                <div class="data-row">
                    <span class="data-label"><i class="fas fa-microchip"></i> Total Devices</span>
                    <span class="data-value">7</span>
                </div>
                <div class="data-row">
                    <span class="data-label"><i class="fas fa-map-marker-alt"></i> Locations</span>
                    <span class="data-value">3</span>
                </div>
                <div class="data-row">
                    <span class="data-label"><i class="fas fa-database"></i> Data Points Today</span>
                    <span class="data-value">1,245</span>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary close-modal">Close</button>
            </div>
        </div>
    </div>

    <!-- Data Visualisation Modal -->
    <div id="dataVisualisationModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-chart-line"></i> Data Visualization</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <p>Explore and analyze your IoT device data with powerful visualization tools.</p>
                <div class="chart-container" style="height: 300px;">
                    <canvas id="modalLineChart"></canvas>
                </div>
                <div class="divider"></div>
                <div class="form-group">
                    <label>Select Data Type</label>
                    <select class="form-control">
                        <option>Temperature</option>
                        <option>Humidity</option>
                        <option>Pressure</option>
                        <option>Power Consumption</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Time Range</label>
                    <select class="form-control">
                        <option>Last 24 Hours</option>
                        <option>Last 7 Days</option>
                        <option>Last 30 Days</option>
                        <option>Custom Range</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary close-modal">Close</button>
                <button class="btn btn-primary">Export Data</button>
            </div>
        </div>
    </div>



    <!-- Devices & Sensors Modal -->
    <div id="devicesModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-microchip"></i> Devices & Sensors</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <button class="btn btn-primary" style="margin-bottom: 15px;" onclick="openAddModal('addDeviceModal')">
                    <i class="fas fa-plus"></i> Add New Device
                </button>
                <table class="users-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Device Name</th>
                            <th>Type</th>
                            <th>Location</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>1</td>
                            <td>Marsabit Sensor 1</td>
                            <td>Temperature</td>
                            <td>Marsabit</td>
                            <td><span class="status-indicator status-online"></span> Online</td>
                            <td>
                                <button class="action-btn edit-btn"><i class="fas fa-edit"></i> Edit</button>
                                <button class="action-btn delete-btn"><i class="fas fa-trash"></i> Delete</button>
                            </td>
                        </tr>
                        <tr>
                            <td>2</td>
                            <td>Wajir Sensor 1</td>
                            <td>Humidity</td>
                            <td>Wajir</td>
                            <td><span class="status-indicator status-online"></span> Online</td>
                            <td>
                                <button class="action-btn edit-btn"><i class="fas fa-edit"></i> Edit</button>
                                <button class="action-btn delete-btn"><i class="fas fa-trash"></i> Delete</button>
                            </td>
                        </tr>
                        <tr>
                            <td>3</td>
                            <td>Moyale Sensor 1</td>
                            <td>Temperature</td>
                            <td>Moyale</td>
                            <td><span class="status-indicator status-offline"></span> Offline</td>
                            <td>
                                <button class="action-btn edit-btn"><i class="fas fa-edit"></i> Edit</button>
                                <button class="action-btn delete-btn"><i class="fas fa-trash"></i> Delete</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary close-modal">Close</button>
            </div>
        </div>
    </div>

    <div id="addDeviceModal" class="modal">
        <div class="modal-content" style="max-width: 600px;">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-microchip"></i> Add New Device</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <form id="deviceForm">
                    <div class="form-group">
                        <label for="deviceName">Device Name</label>
                        <input type="text" class="form-control" id="deviceName" placeholder="Enter device name"
                            required>
                    </div>
                    <div class="form-group">
                        <label for="deviceType">Device Type</label>
                        <select class="form-control" id="deviceType" required>
                            <option value="">Select device type</option>
                            <option value="temperature">Temperature Sensor</option>
                            <option value="humidity">Humidity Sensor</option>
                            <option value="pressure">Pressure Sensor</option>
                            <option value="gateway">Gateway Device</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="deviceLocation">Location</label>
                        <select class="form-control" id="deviceLocation" required>
                            <option value="">Select location</option>
                            <option value="marsabit">Marsabit</option>
                            <option value="wajir">Wajir</option>
                            <option value="moyale">Moyale</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="deviceId">Device ID</label>
                        <input type="text" class="form-control" id="deviceId" placeholder="Enter device ID" required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary close-modal">Cancel</button>
                <button type="submit" form="deviceForm" class="btn btn-primary">Save Device</button>
            </div>
        </div>
    </div>


    <!-- Alerts Modal -->
    <div id="alertsModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-bell"></i> Alerts</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <div class="alert-item" style="padding: 10px; border-bottom: 1px solid #eee; margin-bottom: 10px;">
                    <div style="display: flex; justify-content: space-between;">
                        <strong><i class="fas fa-exclamation-triangle" style="color: #fbbc05;"></i> High Temperature
                            Alert</strong>
                        <small>10 minutes ago</small>
                    </div>
                    <p>Marsabit Sensor 1 reported temperature above threshold (85°F)</p>
                </div>
                <div class="alert-item" style="padding: 10px; border-bottom: 1px solid #eee; margin-bottom: 10px;">
                    <div style="display: flex; justify-content: space-between;">
                        <strong><i class="fas fa-exclamation-circle" style="color: #ea4335;"></i> Device
                            Offline</strong>
                        <small>2 hours ago</small>
                    </div>
                    <p>Moyale Sensor 1 is not responding</p>
                </div>
                <div class="alert-item" style="padding: 10px; border-bottom: 1px solid #eee; margin-bottom: 10px;">
                    <div style="display: flex; justify-content: space-between;">
                        <strong><i class="fas fa-info-circle" style="color: #1a73e8;"></i> Low Humidity Alert</strong>
                        <small>5 hours ago</small>
                    </div>
                    <p>Wajir Sensor 1 reported humidity below threshold (30%)</p>
                </div>
                <div class="form-group">
                    <label>Alert Preferences</label>
                    <select class="form-control">
                        <option>All Alerts</option>
                        <option>Critical Only</option>
                        <option>Warnings and Critical</option>
                        <option>None</option>
                    </select>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary close-modal">Close</button>
                <button class="btn btn-primary">Configure Alerts</button>
            </div>
        </div>
    </div>

    <!-- User Management Modal -->
    <div id="userManagementModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-users"></i> User Management</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <button id="addUserBtn" class="btn btn-primary" style="margin-bottom: 15px;">
                    <i class="fas fa-plus"></i> Add New User
                </button>
                <table class="users-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Name</th>
                            <th>Email</th>
                            <th>Role</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <!-- Rows will be dynamically added here -->
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary close-modal">Close</button>
            </div>
        </div>
    </div>

    <div id="productsModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-shopping-cart"></i> Products</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <button class="btn btn-primary" style="margin-bottom: 15px;" onclick="openAddModal('addProductModal')">
                    <i class="fas fa-plus"></i> Add New Product
                </button>
                <table class="users-table">
                    <thead>
                        <tr>
                            <th>ID</th>
                            <th>Image</th>
                            <th>Product Name</th>
                            <th>SKU</th>
                            <th>Price (KES)</th>
                            <th>Stock</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody id="productsTableBody">
                        <!-- Products will be dynamically added here -->
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary close-modal">Close</button>
                <button class="btn btn-primary">Export Products</button>
            </div>
        </div>
    </div>

    <!-- Password Setup Modal -->
    <div id="passwordSetupModal" class="modal">
        <div class="modal-content" style="max-width: 500px;">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-lock"></i> Set Your Password</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <form id="passwordForm">
                    @csrf
                    <div class="form-group">
                        <label for="new_password">New Password</label>
                        <input type="password" class="form-control" id="new_password" name="new_password"
                            placeholder="Enter new password" required minlength="8">
                        <small class="form-text text-muted">Minimum 8 characters</small>
                    </div>
                    <div class="form-group">
                        <label for="password_confirmation">Confirm Password</label>
                        <input type="password" class="form-control" id="password_confirmation"
                            name="password_confirmation" placeholder="Confirm new password" required>
                    </div>
                    <div id="passwordError" style="color: #ea4335; margin-bottom: 15px; display: none;"></div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary close-modal">Cancel</button>
                <button type="button" id="submitPasswordBtn" class="btn btn-primary">Set Password</button>
            </div>
        </div>
    </div>


    <div id="addProductModal" class="modal">
        <div class="modal-content" style="max-width: 600px;">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-shopping-cart"></i> Add New Product</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <form id="productForm" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group">
                        <label for="product_name">Product Name</label>
                        <input type="text" class="form-control" id="product_name" name="product_name"
                            placeholder="Enter product name" required>
                    </div>
                    <div class="form-group">
                        <label for="product_sku">SKU</label>
                        <input type="text" class="form-control" id="product_sku" name="product_sku"
                            placeholder="Enter product SKU" required>
                    </div>
                    <div class="form-group">
                        <label for="product_price">Price</label>
                        <input type="number" step="0.01" class="form-control" id="product_price" name="product_price"
                            placeholder="Enter price" required>
                    </div>
                    <div class="form-group">
                        <label for="product_count">Stock Quantity</label>
                        <input type="number" class="form-control" id="product_count" name="product_count"
                            placeholder="Enter stock quantity" required>
                    </div>
                    <div class="form-group">
                        <label for="product_desc">Description</label>
                        <textarea class="form-control" id="product_desc" name="product_desc" rows="3"
                            placeholder="Enter product description" required></textarea>
                    </div>
                    <div class="form-group">
                        <label for="product_image">Product Image</label>
                        <input type="file" class="form-control" id="product_image" name="product_image" accept="image/*"
                            required>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary close-modal">Cancel</button>
                <button type="button" id="saveProductBtn" class="btn btn-primary">Save Product</button>
            </div>
        </div>
    </div>


    <div id="addProductModal" class="modal">
        <div class="modal-content" style="max-width: 600px;">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-shopping-cart"></i> Add New Product</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <form id="productForm" enctype="multipart/form-data">
                    @csrf
                    <div class="form-group">
                        <label for="product_name">Product Name</label>
                        <input type="text" class="form-control" id="product_name" name="product_name"
                            placeholder="Enter product name" required>
                    </div>
                    <div class="form-group">
                        <label for="product_sku">SKU</label>
                        <input type="text" class="form-control" id="product_sku" name="product_sku"
                            placeholder="Enter product SKU" required>
                    </div>
                    <div class="form-group">
                        <label for="product_price">Price</label>
                        <input type="number" step="0.01" class="form-control" id="product_price" name="product_price"
                            placeholder="Enter price" required>
                    </div>
                    <div class="form-group">
                        <label for="product_count">Stock Quantity</label>
                        <input type="number" class="form-control" id="product_count" name="product_count"
                            placeholder="Enter stock quantity" required>
                    </div>
                    <div class="form-group">
                        <label for="product_desc">Description</label>
                        <textarea class="form-control" id="product_desc" name="product_desc" rows="3"
                            placeholder="Enter product description" required></textarea>
                    </div>
                    <div class="form-group">
                        <label for="product_image">Product Image</label>
                        <input type="file" class="form-control" id="product_image" name="product_image" accept="image/*"
                            required>
                        <img id="productImagePreview" class="product-image-preview" alt="Product Image Preview">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary close-modal">Cancel</button>
                <button type="submit" form="productForm" class="btn btn-primary">Save Product</button>
            </div>
        </div>
    </div>

    <div id="addProductModal" class="modal">
        <div class="modal-content" style="max-width: 600px;">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-shopping-cart"></i> Add New Product</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <form id="productForm">
                    <div class="form-group">
                        <label for="productName">Product Name</label>
                        <input type="text" class="form-control" id="productName" placeholder="Enter product name"
                            required>
                    </div>
                    <div class="form-group">
                        <label for="productCategory">Category</label>
                        <select class="form-control" id="productCategory" required>
                            <option value="">Select category</option>
                            <option value="sensor">Sensor</option>
                            <option value="gateway">Gateway</option>
                            <option value="accessory">Accessory</option>
                            <option value="software">Software</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="productPrice">Price</label>
                        <input type="number" step="0.01" class="form-control" id="productPrice"
                            placeholder="Enter price" required>
                    </div>
                    <div class="form-group">
                        <label for="productStock">Stock Quantity</label>
                        <input type="number" class="form-control" id="productStock" placeholder="Enter stock quantity"
                            required>
                    </div>
                    <div class="form-group">
                        <label for="productDescription">Description</label>
                        <textarea class="form-control" id="productDescription" rows="3"
                            placeholder="Enter product description"></textarea>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary close-modal">Cancel</button>
                <button type="submit" form="productForm" class="btn btn-primary">Save Product</button>
            </div>
        </div>
    </div>

    <!-- Team Members Modal -->
<div id="teamMembersModal" class="modal">
    <div class="modal-content">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-users-cog"></i> Team Members</h3>
            <span class="close">&times;</span>
        </div>
        <div class="modal-body">
            <button class="btn btn-primary" style="margin-bottom: 15px;" onclick="openAddModal('addTeamMemberModal')">
                <i class="fas fa-plus"></i> Add New Team Member
            </button>
            <table class="users-table">
                <thead>
                    <tr>
                        <th>ID</th>
                        <th>Image</th>
                        <th>Name</th>
                        <th>Role</th>
                        <th>Actions</th>
                    </tr>
                </thead>
                <tbody id="teamMembersTableBody">
                    <!-- Team members will be dynamically added here -->
                </tbody>
            </table>
        </div>
        <div class="modal-footer">
            <button class="btn btn-secondary close-modal">Close</button>
        </div>
    </div>
</div>

<!-- Add Team Member Modal -->
<div id="addTeamMemberModal" class="modal">
    <div class="modal-content" style="max-width: 600px;">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-user-plus"></i> Add Team Member</h3>
            <span class="close">&times;</span>
        </div>
        <div class="modal-body">
            <form id="teamMemberForm" enctype="multipart/form-data">
                <div class="form-group">
                    <label for="teamMemberName">Name</label>
                    <input type="text" class="form-control" id="teamMemberName" name="name" placeholder="Enter name" required>
                </div>
                <div class="form-group">
                    <label for="teamMemberRole">Role</label>
                    <input type="text" class="form-control" id="teamMemberRole" name="role" placeholder="Enter role" required>
                </div>
                <div class="form-group">
                    <label for="teamMemberImage">Image</label>
                    <input type="file" class="form-control" id="teamMemberImage" name="image" accept="image/*" required>
                    <small class="form-text text-muted">Recommended size: 250x250 pixels</small>
                </div>
            </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary close-modal">Cancel</button>
            <button type="button" id="saveTeamMemberBtn" class="btn btn-primary">Save Team Member</button>
        </div>
    </div>
</div>

<!-- Edit Team Member Modal -->
<div id="editTeamMemberModal" class="modal">
    <div class="modal-content" style="max-width: 600px;">
        <div class="modal-header">
            <h3 class="modal-title"><i class="fas fa-user-edit"></i> Edit Team Member</h3>
            <span class="close">&times;</span>
        </div>
        <div class="modal-body">
            <form id="editTeamMemberForm" enctype="multipart/form-data">
                <input type="hidden" id="editTeamMemberId">
                <div class="form-group">
                    <label for="editTeamMemberName">Name</label>
                    <input type="text" class="form-control" id="editTeamMemberName" name="name" placeholder="Enter name" required>
                </div>
                <div class="form-group">
                    <label for="editTeamMemberRole">Role</label>
                    <input type="text" class="form-control" id="editTeamMemberRole" name="role" placeholder="Enter role" required>
                </div>
                <div class="form-group">
                    <label for="editTeamMemberImage">Image</label>
                    <input type="file" class="form-control" id="editTeamMemberImage" name="image" accept="image/*">
                    <small class="form-text text-muted">Leave empty to keep current image</small>
                    <div id="currentTeamMemberImage" style="margin-top: 10px;"></div>
                </div>
            </form>
        </div>
        <div class="modal-footer">
            <button type="button" class="btn btn-secondary close-modal">Cancel</button>
            <button type="button" id="updateTeamMemberBtn" class="btn btn-primary">Update Team Member</button>
        </div>
    </div>
</div>


    <!-- Orders Modal -->
    <div id="ordersModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-file-export"></i> Orders</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <div class="form-group" style="display: flex; gap: 10px;">
                    <select class="form-control" style="flex: 1;">
                        <option>All Orders</option>
                        <option>Pending</option>
                        <option>Completed</option>
                        <option>Cancelled</option>
                    </select>
                    <input type="text" class="form-control" placeholder="Search orders..." style="flex: 2;">
                </div>
                <table class="users-table">
                    <thead>
                        <tr>
                            <th>Order No</th>
                            <th>Customer</th>
                            <th>Phone</th>
                            <th>Product</th>
                            <th>Cost</th>
                            <th>Order Time</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>#1001</td>
                            <td>John Smith</td>
                            <td>2024-04-10</td>
                            <td>KES 29000.99</td>
                            <td><span style="color: #34a853;">Completed</span></td>
                            <td>
                                <button class="action-btn edit-btn"><i class="fas fa-eye"></i> View</button>
                            </td>
                        </tr>
                        <tr>
                            <td>#1002</td>
                            <td>Alice Johnson</td>
                            <td>2024-04-12</td>
                            <td>KES 29000.9</td>
                            <td><span style="color: #fbbc05;">Processing</span></td>
                            <td>
                                <button class="action-btn edit-btn"><i class="fas fa-eye"></i> View</button>
                            </td>
                        </tr>
                        <tr>
                            <td>#1003</td>
                            <td>Robert Brown</td>
                            <td>2024-04-14</td>
                            <td>KES 29000.9</td>
                            <td><span style="color: #1a73e8;">Shipped</span></td>
                            <td>
                                <button class="action-btn edit-btn"><i class="fas fa-eye"></i> View</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary close-modal">Close</button>
                <button class="btn btn-primary">Export Orders</button>
            </div>
        </div>
    </div>
    <div id="emailModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-file-export"></i> All subscribers</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <div class="form-group" style="display: flex; gap: 10px;">
                    <select class="form-control" style="flex: 1;">
                        <option>All subscribers</option>
                    </select>
                    <input type="text" class="form-control" placeholder="Search emails..." style="flex: 2;">
                </div>
                <table class="users-table">
                    <thead>
                        <tr>
                            <th> No</th>
                            <th>Customer</th>
                            <th>EmaiL Address</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>#1001</td>
                            <td>John Smith</td>
                            <td>jsmith@yahoo.com</td>

                        </tr>
                        <tr>
                            <td>#1002</td>
                            <td>Alice Johnson</td>
                            <td>jsmith3@yahoo.com</td>
                        </tr>
                        <tr>
                            <td>#1003</td>
                            <td>Robert Brown</td>
                            <td>jsmi3th@yahoo.com</td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary close-modal">Close</button>
                <button class="btn btn-primary">Export Emails</button>
            </div>
        </div>
    </div>
    <div id="clientsModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-file-export"></i> All clients</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <div class="form-group" style="display: flex; gap: 10px;">
                    <select class="form-control" style="flex: 1;">
                        <option>All Clients</option>
                    </select>
                    <input type="text" class="form-control" placeholder="Search clients..." style="flex: 2;">
                </div>
                <table class="users-table">
                    <thead>
                        <tr>
                            <th> No</th>
                            <th>Customer</th>
                            <th>Date</th>
                            <th>Cost</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>#1001</td>
                            <td>John Smith</td>
                            <td>2024-04-10</td>
                            <td>KES 29000.99</td>
                            <td><span style="color: #34a853;">Completed</span></td>
                            <td>
                                <button class="action-btn edit-btn"><i class="fas fa-eye"></i> View</button>
                            </td>
                        </tr>
                        <tr>
                            <td>#1002</td>
                            <td>Alice Johnson</td>
                            <td>2024-04-12</td>
                            <td>KES 29000.9</td>
                            <td><span style="color: #fbbc05;">Processing</span></td>
                            <td>
                                <button class="action-btn edit-btn"><i class="fas fa-eye"></i> View</button>
                            </td>
                        </tr>
                        <tr>
                            <td>#1003</td>
                            <td>Robert Brown</td>
                            <td>2024-04-14</td>
                            <td>KES 29000.9</td>
                            <td><span style="color: #1a73e8;">Shipped</span></td>
                            <td>
                                <button class="action-btn edit-btn"><i class="fas fa-eye"></i> View</button>
                            </td>
                        </tr>
                    </tbody>
                </table>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary close-modal">Close</button>
                <button class="btn btn-primary">Export All</button>
            </div>
        </div>
    </div>

    <div id="newsModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-globe"></i> News & Blogs</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <button class="btn btn-primary" style="margin-bottom: 15px;" onclick="openAddModal('addArticleModal')">
                    <i class="fas fa-plus"></i> Add New Article
                </button>
                <div id="articleListContainer" class="article-list">
                    <!-- Articles will be loaded dynamically here -->
                    <div class="loading-spinner" style="text-align: center; padding: 20px;">
                        <i class="fas fa-spinner fa-spin"></i> Loading articles...
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary close-modal">Close</button>
            </div>
        </div>
    </div>

    <!-- Add Article Modal with WYSIWYG Editor -->
    <div id="addArticleModal" class="modal">
        <div class="modal-content" style="max-width: 800px;">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-globe"></i> Add New Article</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <form id="articleForm">
                    <div class="form-group">
                        <label for="articleTitle">Title</label>
                        <input type="text" class="form-control" id="articleTitle" placeholder="Enter article title"
                            required>
                    </div>
                    <div class="form-group">
                        <label for="articleAuthor">Author</label>
                        <input type="text" class="form-control" id="articleAuthor" placeholder="Enter author name"
                            required>
                    </div>
                    <div class="form-group">
                        <label for="articleCategory">Category</label>
                        <select class="form-control" id="articleCategory" required>
                            <option value="">Select category</option>
                            <option value="news">News</option>
                            <option value="blog">Blog</option>
                            <option value="tutorial">Tutorial</option>
                            <option value="announcement">Announcement</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="articleContent">Content</label>
                        <!-- WYSIWYG Editor container -->
                        <div id="editor" style="height: 300px;"></div>
                        <textarea class="form-control" id="articleContent" style="display:none;"></textarea>
                    </div>
                    <div class="form-group">
                        <label for="articleImage">Featured Image</label>
                        <input type="file" class="form-control" id="articleImage" accept="image/*">
                        <small class="form-text text-muted">Recommended size: 1200x630 pixels</small>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary close-modal">Cancel</button>
                <button type="button" id="publishArticleBtn" class="btn btn-primary">Publish Article</button>
            </div>
        </div>
    </div>

    <div id="addArticleModal" class="modal">
        <div class="modal-content" style="max-width: 800px;">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-globe"></i> Add New Article</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <form id="articleForm">
                    <div class="form-group">
                        <label for="articleTitle">Title</label>
                        <input type="text" class="form-control" id="articleTitle" placeholder="Enter article title"
                            required>
                    </div>
                    <div class="form-group">
                        <label for="articleAuthor">Author</label>
                        <input type="text" class="form-control" id="articleAuthor" placeholder="Enter author name"
                            required>
                    </div>
                    <div class="form-group">
                        <label for="articleCategory">Category</label>
                        <select class="form-control" id="articleCategory" required>
                            <option value="">Select category</option>
                            <option value="news">News</option>
                            <option value="blog">Blog</option>
                            <option value="tutorial">Tutorial</option>
                            <option value="announcement">Announcement</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="articleContent">Content</label>
                        <textarea class="form-control" id="articleContent" rows="10" placeholder="Enter article content"
                            required></textarea>
                    </div>
                    <div class="form-group">
                        <label for="articleImage">Featured Image</label>
                        <input type="file" class="form-control" id="articleImage">
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary close-modal">Cancel</button>
                <button type="submit" form="articleForm" class="btn btn-primary">Publish Article</button>
            </div>
        </div>
    </div>

    <!-- Settings Modal -->
    <div id="settingsModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-cog"></i> Settings</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label>Dashboard Theme</label>
                    <select class="form-control">
                        <option>Light</option>
                        <option>Dark</option>
                        <option>System Default</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Data Refresh Interval</label>
                    <select class="form-control">
                        <option>30 seconds</option>
                        <option>1 minute</option>
                        <option>5 minutes</option>
                        <option>15 minutes</option>
                        <option>Manual refresh</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Timezone</label>
                    <select class="form-control">
                        <option>UTC</option>
                        <option>Africa/Nairobi (EAT)</option>
                        <option>America/New_York (EST)</option>
                        <option>Europe/London (GMT)</option>
                    </select>
                </div>
                <div class="form-group">
                    <label>Notification Preferences</label>
                    <div style="margin-top: 5px;">
                        <label style="display: flex; align-items: center; margin-bottom: 8px;">
                            <input type="checkbox" style="margin-right: 8px;"> Email Notifications
                        </label>
                        <label style="display: flex; align-items: center; margin-bottom: 8px;">
                            <input type="checkbox" style="margin-right: 8px;"> Push Notifications
                        </label>
                        <label style="display: flex; align-items: center;">
                            <input type="checkbox" style="margin-right: 8px;"> SMS Alerts
                        </label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button class="btn btn-secondary close-modal">Close</button>
                <button class="btn btn-primary">Save Settings</button>
            </div>
        </div>
    </div>

    <!-- Add User Modal -->
    <!-- Add User Modal -->
    <div id="addUserModal" class="modal">
        <div class="modal-content" style="max-width: 600px;">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-user-plus"></i> Add New User</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <form id="userForm">
                    <!-- First Name -->
                    <div class="form-group">
                        <label for="fname">First Name</label>
                        <input type="text" class="form-control" id="fname" placeholder="Enter first name" required>
                    </div>

                    <!-- Last Name -->
                    <div class="form-group">
                        <label for="lname">Last Name</label>
                        <input type="text" class="form-control" id="lname" placeholder="Enter last name" required>
                    </div>

                    <!-- Department -->
                    <div class="form-group">
                        <label for="dept">Department</label>
                        {{-- <input type="text" class="form-control" id="dept" placeholder="Enter department" required>
                        --}}
                        <select class="form-control" id="dept" required>
                            <option value="">Select Department</option>
                            <option value="Tech">Technical</option>
                            <option value="Marketing">Marketing</option>
                            <option value="Business">Business</option>
                            <option value="Administration">Admin</option>

                            {{-- <option value="viewer">Viewer</option> --}}
                        </select>
                    </div>

                    <!-- Phone Number -->
                    <div class="form-group">
                        <label for="phone">Phone Number</label>
                        <input type="text" class="form-control" id="phone" placeholder="Enter phone number" required>
                    </div>

                    <!-- Email Address -->
                    <div class="form-group">
                        <label for="email">Email Address</label>
                        <input type="email" class="form-control" id="email" placeholder="Enter email" required>
                    </div>

                    <!-- Role -->
                    <div class="form-group">
                        <label for="role">Role</label>
                        <select class="form-control" id="role" required>
                            <option value="">Select role</option>
                            <option value="admin">Admin</option>
                            <option value="editor">Super Admin</option>
                            {{-- <option value="viewer">Viewer</option> --}}
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary close-modal">Cancel</button>
                <button type="submit" form="userForm" class="btn btn-primary">Save User</button>
            </div>
        </div>
    </div>
    <div id="editUserModal" class="modal">
        <div class="modal-content" style="max-width: 600px;">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-user-edit"></i> Edit User</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <form id="editUserForm">
                    <input type="hidden" id="editUserId">
                    <div class="form-group">
                        <label for="editFname">First Name</label>
                        <input type="text" class="form-control" id="editFname" placeholder="Enter first name" required>
                    </div>
                    <div class="form-group">
                        <label for="editLname">Last Name</label>
                        <input type="text" class="form-control" id="editLname" placeholder="Enter last name" required>
                    </div>
                    <div class="form-group">
                        <label for="editDept">Department</label>
                        <select class="form-control" id="editDept" required>
                            <option value="">Select Department</option>
                            <option value="Tech">Technical</option>
                            <option value="Marketing">Marketing</option>
                            <option value="Business">Business</option>
                            <option value="Administration">Admin</option>
                        </select>
                    </div>
                    <div class="form-group">
                        <label for="editPhone">Phone Number</label>
                        <input type="text" class="form-control" id="editPhone" placeholder="Enter phone number" required>
                    </div>
                    <div class="form-group">
                        <label for="editEmail">Email Address</label>
                        <input type="email" class="form-control" id="editEmail" placeholder="Enter email" required>
                    </div>
                    <div class="form-group">
                        <label for="editRole">Role</label>
                        <select class="form-control" id="editRole" required>
                            <option value="">Select role</option>
                            <option value="admin">Admin</option>
                            <option value="editor">Super Admin</option>
                        </select>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary close-modal">Cancel</button>
                <button type="button" id="updateUserBtn" class="btn btn-primary">Update User</button>
            </div>
        </div>
    </div>

    <div id="editProductModal" class="modal">
        <div class="modal-content" style="max-width: 600px;">
            <div class="modal-header">
                <h3 class="modal-title"><i class="fas fa-edit"></i> Edit Product</h3>
                <span class="close">&times;</span>
            </div>
            <div class="modal-body">
                <form id="editProductForm" enctype="multipart/form-data">
                    <input type="hidden" id="editProductId">
                    <div class="form-group">
                        <label for="editProductName">Product Name</label>
                        <input type="text" class="form-control" id="editProductName" placeholder="Enter product name" required>
                    </div>
                    <div class="form-group">
                        <label for="editProductSku">SKU</label>
                        <input type="text" class="form-control" id="editProductSku" placeholder="Enter product SKU" required>
                    </div>
                    <div class="form-group">
                        <label for="editProductPrice">Price</label>
                        <input type="number" step="0.01" class="form-control" id="editProductPrice" placeholder="Enter price" required>
                    </div>
                    <div class="form-group">
                        <label for="editProductCount">Stock Quantity</label>
                        <input type="number" class="form-control" id="editProductCount" placeholder="Enter stock quantity" required>
                    </div>
                    <div class="form-group">
                        <label for="editProductDesc">Description</label>
                        <textarea class="form-control" id="editProductDesc" rows="3" placeholder="Enter product description" required></textarea>
                    </div>
                    <div class="form-group">
                        <label for="editProductImage">Product Image</label>
                        <input type="file" class="form-control" id="editProductImage" accept="image/*">
                        <small class="form-text text-muted">Leave empty to keep current image</small>
                        <div id="currentProductImageContainer" style="margin-top: 10px;"></div>
                    </div>
                </form>
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-secondary close-modal">Cancel</button>
                <button type="button" id="updateProductBtn" class="btn btn-primary">Update Product</button>
            </div>
        </div>
    </div>
    

    <script src="https://unpkg.com/leaflet@1.9.3/dist/leaflet.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/axios/dist/axios.min.js"></script>
    <!-- Include Quill stylesheet -->


    <script>
        function openAddModal(modalId) {
    // Close all modals first
    document.querySelectorAll('.modal').forEach(modal => {
        modal.style.display = 'none';
    });
    // Open the requested modal
    const modal = document.getElementById(modalId);
    if (modal) {
        modal.style.display = 'block';
    }
}

let quillEditor; // Global reference to Quill editor

function initializeQuillEditor() {
    quillEditor = new Quill('#editor', {
        theme: 'snow',
        modules: {
            toolbar: [
                [{ 'header': [1, 2, 3, false] }],
                ['bold', 'italic', 'underline', 'strike'],
                [{ 'list': 'ordered'}, { 'list': 'bullet' }],
                ['link', 'image'],
                ['clean']
            ]
        },
        placeholder: 'Write your article content here...',
    });

    // Update hidden textarea with editor content
    quillEditor.on('text-change', function() {
        document.getElementById('articleContent').value = quillEditor.root.innerHTML;
    });
}

function fetchAndDisplayArticles() {
    axios.get('/majik-blogs')
        .then(response => {
            const articles = response.data;
            const container = document.getElementById('articleListContainer');
            container.innerHTML = ''; // Clear existing content

            if (articles.length > 0) {
                articles.forEach(article => {
                    const articleItem = document.createElement('div');
                    articleItem.className = 'article-item';
                    articleItem.style.padding = '15px';
                    articleItem.style.borderBottom = '1px solid #eee';
                    articleItem.style.marginBottom = '10px';
                    
                    // Format date
                    const postedDate = new Date(article.posted_at);
                    const formattedDate = postedDate.toLocaleDateString('en-US', {
                        year: 'numeric',
                        month: 'long',
                        day: 'numeric'
                    });

                    articleItem.innerHTML = `
                        <h4 style="margin-bottom: 5px;">${article.title}</h4>
                        <p style="color: #666; margin-bottom: 10px; font-size: 14px;">
                            Posted on ${formattedDate} by ${article.author}
                            <span class="badge" style="background-color: #f0f0f0; color: #555; margin-left: 10px;">
                                ${article.category}
                            </span>
                        </p>
                        <div style="margin-bottom: 10px;">
                            ${article.content.substring(0, 200)}...
                        </div>
                        <div>
                            <button class="action-btn edit-btn" data-id="${article.id}">
                                <i class="fas fa-edit"></i> Edit
                            </button>
                            <button class="action-btn delete-btn" data-id="${article.id}">
                                <i class="fas fa-trash"></i> Delete
                            </button>
                            <button class="action-btn preview-btn" data-id="${article.id}" 
                                style="background-color: #34a853; color: white;">
                                <i class="fas fa-eye"></i> Preview
                            </button>
                        </div>
                    `;
                    container.appendChild(articleItem);
                });

                // Add event listeners to the new buttons
                addArticleActionListeners();
            } else {
                container.innerHTML = `
                    <div style="text-align: center; padding: 20px; color: #666;">
                        No articles found. Click "Add New Article" to create one.
                    </div>
                `;
            }
        })
        .catch(error => {
            console.error('Error fetching articles:', error);
            document.getElementById('articleListContainer').innerHTML = `
                <div style="text-align: center; padding: 20px; color: #ea4335;">
                    Failed to load articles. Please try again.
                </div>
            `;
        });
}

function addArticleActionListeners() {
    // Edit button
    document.querySelectorAll('.edit-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const articleId = this.getAttribute('data-id');
            // Implement edit functionality
            alert(`Edit article with ID: ${articleId}`);
        });
    });

    // Delete button
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const articleId = this.getAttribute('data-id');
            if (confirm('Are you sure you want to delete this article?')) {
                axios.delete(`/blogs/${articleId}`)
                    .then(response => {
                        alert('Article deleted successfully');
                        fetchAndDisplayArticles();
                    })
                    .catch(error => {
                        console.error('Error deleting article:', error);
                        alert('Failed to delete article. Please try again.');
                    });
            }
        });
    });

    // Preview button
    document.querySelectorAll('.preview-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const articleId = this.getAttribute('data-id');
            window.open(`/blogs/${articleId}`, '_blank');
        });
    });
}


document.addEventListener('DOMContentLoaded', function() {
    initializeQuillEditor();

    // Initialize modals and sidebar navigation
    const menuItems = document.querySelectorAll('.sidebar li');
    menuItems.forEach(item => {
        item.addEventListener('click', function() {
            // Remove active class from all items
            menuItems.forEach(i => i.classList.remove('active'));
            // Add active class to clicked item
            this.classList.add('active');
            // Get the modal ID from data attribute
            const modalId = this.getAttribute('data-modal');
            if (modalId) {
                const modal = document.getElementById(modalId);
                if (modal) {
                    modal.style.display = 'block';
                    // Load specific content when modals open
                    if (modalId === 'userManagementModal') {
                        fetchAndDisplayUsers();
                    } else if (modalId === 'productsModal') {
                        fetchAndDisplayProducts();
                    }else if (modalId === 'ordersModal') {
                        fetchAndDisplayOrders(); 
                    } else if (modalId === 'newsModal') {
                        fetchAndDisplayArticles(); 
                    }  else if (modalId === 'teamMembersModal') {
                fetchAndDisplayTeamMembers();
             }
                }
            }
        });
    });
    @if($showModal ?? false)
        console.log('Showing password modal'); // Debugging line
        const passwordModal = document.getElementById('passwordSetupModal');
        if (passwordModal) {
            passwordModal.style.display = 'block';
            
            // Make modal non-dismissible
            passwordModal.style.backgroundColor = 'rgba(0,0,0,0.7)';
            passwordModal.querySelector('.close').style.display = 'none';
            
            // Prevent closing when clicking outside
            passwordModal.addEventListener('click', function(e) {
                if (e.target === this) {
                    e.preventDefault();
                    e.stopPropagation();
                }
            });
        } else {
            console.error('Password modal element not found!');
        }
    @endif

    // Password form submission handler
    document.getElementById('submitPasswordBtn')?.addEventListener('click', function() {
        const newPassword = document.getElementById('new_password').value;
        const confirmPassword = document.getElementById('password_confirmation').value;
        const errorElement = document.getElementById('passwordError');
        
        // Reset error state
        errorElement.style.display = 'none';
        
        // Validate passwords
        if (newPassword !== confirmPassword) {
            errorElement.textContent = 'Passwords do not match';
            errorElement.style.display = 'block';
            return;
        }
        
        if (newPassword.length < 8) {
            errorElement.textContent = 'Password must be at least 8 characters';
            errorElement.style.display = 'block';
            return;
        }
        
        // Submit the form
        axios.post('/set-password', {
            new_password: newPassword,
            password_confirmation: confirmPassword,
            _token: document.querySelector('meta[name="csrf-token"]').content
        })
        .then(response => {
            if (response.data.success) {
                alert('Password set successfully!');
                window.location.reload(); // Refresh to remove the modal
            } else {
                throw new Error(response.data.message || 'Failed to set password');
            }
        })
        .catch(error => {
            console.error('Error setting password:', error);
            errorElement.textContent = error.response?.data?.message || 'Failed to set password. Please try again.';
            errorElement.style.display = 'block';
        });
    });


    // Password form submission
    document.getElementById('submitPasswordBtn')?.addEventListener('click', function() {
        const newPassword = document.getElementById('new_password').value;
        const confirmPassword = document.getElementById('password_confirmation').value;
        const errorElement = document.getElementById('passwordError');
        
        // Reset error state
        errorElement.style.display = 'none';
        
        // Validate passwords
        if (newPassword !== confirmPassword) {
            errorElement.textContent = 'Passwords do not match';
            errorElement.style.display = 'block';
            return;
        }
        
        if (newPassword.length < 8) {
            errorElement.textContent = 'Password must be at least 8 characters';
            errorElement.style.display = 'block';
            return;
        }
        
        // Submit the form
        axios.post('/set-password', {
            new_password: newPassword,
            password_confirmation: confirmPassword,
            _token: document.querySelector('meta[name="csrf-token"]').content
        })
        .then(response => {
            if (response.data.success) {
                alert('Password set successfully!');
                window.location.reload(); // Refresh to remove the modal
            } else {
                throw new Error(response.data.message || 'Failed to set password');
            }
        })
        .catch(error => {
            console.error('Error setting password:', error);
            errorElement.textContent = error.response?.data?.message || 'Failed to set password. Please try again.';
            errorElement.style.display = 'block';
        });
    });

    // Team Member Management Functions
function fetchAndDisplayTeamMembers() {
    axios.get('/team/list')
        .then(response => {
            const teamMembers = response.data;
            const tbody = document.getElementById('teamMembersTableBody');
            tbody.innerHTML = ''; // Clear existing rows

            if (teamMembers.length > 0) {
                teamMembers.forEach(member => {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>${member.id}</td>
                        <td>
                            ${member.image_path ? 
                                `<img src="/${member.image_path}" class="product-image" alt="${member.name}">` : 
                                'No Image'}
                        </td>
                        <td>${member.name}</td>
                        <td>${member.role}</td>
                        <td>
                            <button class="action-btn edit-btn" data-id="${member.id}"><i class="fas fa-edit"></i> Edit</button>
                            <button class="action-btn delete-btn" data-id="${member.id}"><i class="fas fa-trash"></i> Delete</button>
                        </td>
                    `;
                    tbody.appendChild(row);
                });
                addTeamMemberEditDeleteListeners();
            } else {
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td colspan="5" style="text-align: center;">No team members found</td>
                `;
                tbody.appendChild(row);
            }
        })
        .catch(error => {
            console.error('Error fetching team members:', error);
            alert('Failed to load team members. Please try again.');
        });
}

function addTeamMemberEditDeleteListeners() {
    document.querySelectorAll('#teamMembersTableBody .edit-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const memberId = this.getAttribute('data-id');
            axios.get(`/team/${memberId}`)
                .then(response => {
                    const member = response.data;
                    openEditTeamMemberModal(member);
                })
                .catch(error => {
                    console.error('Error fetching team member:', error);
                    alert('Failed to load team member data. Please try again.');
                });
        });
    });

    document.querySelectorAll('#teamMembersTableBody .delete-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const memberId = this.getAttribute('data-id');
            if (confirm('Are you sure you want to delete this team member?')) {
                axios.delete(`/team/${memberId}`)
                    .then(response => {
                        alert('Team member deleted successfully');
                        fetchAndDisplayTeamMembers();
                    })
                    .catch(error => {
                        console.error('Error deleting team member:', error);
                        alert('Failed to delete team member. Please try again.');
                    });
            }
        });
    });
}

function openEditTeamMemberModal(member) {
    document.getElementById('editTeamMemberId').value = member.id;
    document.getElementById('editTeamMemberName').value = member.name;
    document.getElementById('editTeamMemberRole').value = member.role;
    
    const imageContainer = document.getElementById('currentTeamMemberImage');
    imageContainer.innerHTML = '';
    if (member.image_path) {
        imageContainer.innerHTML = `
            <p>Current Image:</p>
            <img src="/${member.image_path}" class="product-image" alt="Current Team Member Image">
        `;
    }
    
    document.querySelectorAll('.modal').forEach(modal => {
        modal.style.display = 'none';
    });
    document.getElementById('editTeamMemberModal').style.display = 'block';
}

// Save Team Member
document.getElementById('saveTeamMemberBtn')?.addEventListener('click', function() {
    const form = document.getElementById('teamMemberForm');
    const formData = new FormData(form);

    axios.post('/team/store', formData, {
        headers: {
            'Content-Type': 'multipart/form-data'
        }
    })
    .then(response => {
        alert('Team member added successfully!');
        document.getElementById('addTeamMemberModal').style.display = 'none';
        document.getElementById('teamMembersModal').style.display = 'block';
        form.reset();
        fetchAndDisplayTeamMembers();
    })
    .catch(error => {
        console.error('Error adding team member:', error);
        if (error.response && error.response.data) {
            if (error.response.data.errors) {
                const errors = error.response.data.errors;
                let errorMessage = '';
                for (const field in errors) {
                    errorMessage += `${errors[field][0]}\n`;
                }
                alert(errorMessage);
            } else {
                alert(`Failed to add team member: ${error.response.data.message}`);
            }
        } else {
            alert('Failed to add team member. Please try again.');
        }
    });
});

// Update Team Member
document.getElementById('updateTeamMemberBtn')?.addEventListener('click', function() {
    const memberId = document.getElementById('editTeamMemberId').value;
    const formData = new FormData(document.getElementById('editTeamMemberForm'));
    
    axios.post(`/team/${memberId}`, formData, {
        headers: {
            'Content-Type': 'multipart/form-data'
        },
        params: {
            _method: 'PUT'
        }
    })
    .then(response => {
        alert('Team member updated successfully!');
        document.getElementById('editTeamMemberModal').style.display = 'none';
        document.getElementById('teamMembersModal').style.display = 'block';
        fetchAndDisplayTeamMembers();
    })
    .catch(error => {
        console.error('Error updating team member:', error);
        alert(error.response?.data?.message || 'Failed to update team member. Please try again.');
    });
});
    

    // Animate graph bars on load
    const graphBars = document.querySelectorAll('.graph-bar');
    graphBars.forEach(bar => {
        const originalHeight = bar.style.height;
        bar.style.height = '0%';
        setTimeout(() => {
            bar.style.height = originalHeight;
        }, 100);
    });

    // Simulate live data updates
    setInterval(() => {
        const randomValue = Math.floor(Math.random() * 20) + 70;
        document.querySelector('.card:nth-child(1) .stat-value').innerHTML = 
            `<i class="fas fa-server stat-icon"></i> ${Math.floor(Math.random() * 2) + 6}`;
    }, 5000);

    // Initialize the main devices map
    const devicesMap = L.map('devicesMap').setView([1.5, 38.5], 6);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        maxZoom: 19,
        attribution: '&copy; <a href="https://www.openstreetmap.org/copyright">OpenStreetMap</a> contributors'
    }).addTo(devicesMap);

    // Custom icon
    const deviceIcon = L.icon({
        iconUrl: 'https://cdn-icons-png.flaticon.com/512/684/684908.png',
        iconSize: [25, 25],
        iconAnchor: [12, 25],
        popupAnchor: [1, -25]
    });

    // Town data with coordinates
    const towns = [
        {
            name: "Marsabit",
            lat: 2.3333,
            lng: 37.9167,
            description: "Marsabit Town",
            devices: 3
        },
        {
            name: "Wajir",
            lat: 1.7500,
            lng: 40.0833,
            description: "Wajir Town",
            devices: 2
        },
        {
            name: "Moyale",
            lat: 3.5333,
            lng: 39.0500,
            description: "Moyale Town",
            devices: 2
        }
    ];

    // Add markers for each town
    towns.forEach(town => {
        const marker = L.marker([town.lat, town.lng], {icon: deviceIcon}).addTo(devicesMap)
            .bindPopup(`
                <b>${town.name}</b><br>
                <small>${town.description}</small><br>
                <b>Devices:</b> ${town.devices}<br>
                <b>Coordinates:</b> ${town.lat}° N, ${town.lng}° E
            `);
    });

    // Fit the map to show all markers
    if (towns.length > 0) {
        const group = new L.featureGroup(towns.map(t => L.marker([t.lat, t.lng])));
        devicesMap.fitBounds(group.getBounds().pad(0.2));
    }

    // Initialize trends mini map
    const trendsMap = L.map('trendsMap').setView([1.5, 38.5], 6);
    L.tileLayer('https://{s}.tile.openstreetmap.org/{z}/{x}/{y}.png', {
        maxZoom: 15,
        attribution: ''
    }).addTo(trendsMap);

    // Initialize pie chart for devices distribution
    const pieCtx = document.getElementById('devicesPieChart').getContext('2d');
    const devicesPieChart = new Chart(pieCtx, {
        type: 'pie',
        data: {
            labels: ['Marsabit', 'Wajir', 'Moyale'],
            datasets: [{
                data: [3, 2, 2],
                backgroundColor: [
                    '#1a73e8',
                    '#34a853',
                    '#fbbc05'
                ],
                borderWidth: 1
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'bottom'
                },
                tooltip: {
                    callbacks: {
                        label: function(context) {
                            return `${context.label}: ${context.raw} devices`;
                        }
                    }
                }
            }
        }
    });

    // Initialize line chart for data visualization modal
    const modalLineCtx = document.getElementById('modalLineChart').getContext('2d');
    const modalLineChart = new Chart(modalLineCtx, {
        type: 'line',
        data: {
            labels: ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul'],
            datasets: [{
                label: 'Temperature (°F)',
                data: [65, 59, 80, 81, 56, 55, 40],
                borderColor: '#1a73e8',
                backgroundColor: 'rgba(26, 115, 232, 0.1)',
                fill: true,
                tension: 0.4
            }, {
                label: 'Humidity (%)',
                data: [28, 48, 40, 19, 86, 27, 90],
                borderColor: '#34a853',
                backgroundColor: 'rgba(52, 168, 83, 0.1)',
                fill: true,
                tension: 0.4
            }]
        },
        options: {
            responsive: true,
            maintainAspectRatio: false,
            plugins: {
                legend: {
                    position: 'top',
                },
                tooltip: {
                    mode: 'index',
                    intersect: false,
                }
            },
            scales: {
                y: {
                    beginAtZero: true
                }
            }
        }
    });

    // Modal functionality
    const closeButtons = document.querySelectorAll('.close, .close-modal');
    const userForm = document.getElementById('userForm');
    const addUserBtn = document.getElementById('addUserBtn');
    const addUserModal = document.getElementById('addUserModal');
    const userManagementModal = document.getElementById('userManagementModal');

    // Function to open specific modals
    function openAddModal(modalId) {
        // Close all modals first
        document.querySelectorAll('.modal').forEach(modal => {
            modal.style.display = 'none';
        });
        // Open the requested modal
        const modal = document.getElementById(modalId);
        if (modal) {
            modal.style.display = 'block';
        }
    }

    // User Management Functions
    function fetchAndDisplayUsers() {
        axios.get('/userlist')
            .then(response => {
                const users = response.data; 
                const tbody = document.querySelector('#userManagementModal table tbody');
                tbody.innerHTML = ''; // Clear existing rows

                if (users.length > 0) {
                    users.forEach(user => {
                        const row = document.createElement('tr');
                        row.innerHTML = `
                            <td>${user.id}</td>
                            <td>${user.fname} ${user.lname}</td>
                            <td>${user.email}</td>
                            <td>${user.role}</td>
                            <td><span class="status-indicator ${user.status === 'Active' ? 'status-online' : 'status-offline'}"></span> ${user.status}</td>
                            <td>
                                <button class="action-btn edit-btn" data-id="${user.id}"><i class="fas fa-edit"></i> Edit</button>
                                <button class="action-btn delete-btn" data-id="${user.id}"><i class="fas fa-trash"></i> Delete</button>
                            </td>
                        `;
                        tbody.appendChild(row);
                    });
                    addEditDeleteListeners(); // Attach event listeners to new buttons
                } else {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td colspan="6" style="text-align: center;">No users found</td>
                    `;
                    tbody.appendChild(row);
                }
            })
            .catch(error => {
                console.error('Error fetching users:', error);
                alert('Failed to load users. Please try again.');
            });
    }

    function addEditDeleteListeners() {
    document.querySelectorAll('.edit-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const userId = this.getAttribute('data-id');
            axios.get(`/users/${userId}`)
                .then(response => {
                    const user = response.data;
                    openEditUserModal(user);
                })
                .catch(error => {
                    console.error('Error fetching user:', error);
                    alert('Failed to load user data. Please try again.');
                });
        });
    });

    // Keep the existing delete functionality
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const userId = this.getAttribute('data-id');
            if (confirm('Are you sure you want to delete this user?')) {
                axios.delete(`/users/${userId}`)
                    .then(response => {
                        alert('User deleted successfully');
                        fetchAndDisplayUsers();
                    })
                    .catch(error => {
                        console.error('Error deleting user:', error);
                        alert('Failed to delete user. Please try again.');
                    });
            }
        });
    });
}

    // function addEditDeleteListeners() {
    //     document.querySelectorAll('.edit-btn').forEach(btn => {
    //         btn.addEventListener('click', function() {
    //             const userId = this.getAttribute('data-id');
    //             alert(`Edit user with ID: ${userId}`);
    //             // Implement edit functionality here
    //         });
    //     });

    //     document.querySelectorAll('.delete-btn').forEach(btn => {
    //         btn.addEventListener('click', function() {
    //             const userId = this.getAttribute('data-id');
    //             if (confirm('Are you sure you want to delete this user?')) {
    //                 axios.delete(`/users/${userId}`)
    //                     .then(response => {
    //                         alert('User deleted successfully');
    //                         fetchAndDisplayUsers(); // Refresh the list after deletion
    //                     })
    //                     .catch(error => {
    //                         console.error('Error deleting user:', error);
    //                         alert('Failed to delete user. Please try again.');
    //                     });
    //             }
    //         });
    //     });
    // }
    function openEditUserModal(user) {
    document.getElementById('editUserId').value = user.id;
    document.getElementById('editFname').value = user.fname;
    document.getElementById('editLname').value = user.lname;
    document.getElementById('editDept').value = user.dept;
    document.getElementById('editPhone').value = user.phone;
    document.getElementById('editEmail').value = user.email;
    document.getElementById('editRole').value = user.role;
    
    document.querySelectorAll('.modal').forEach(modal => {
        modal.style.display = 'none';
    });
    document.getElementById('editUserModal').style.display = 'block';
}

function openEditProductModal(product) {
    document.getElementById('editProductId').value = product.id;
    document.getElementById('editProductName').value = product.name;
    document.getElementById('editProductSku').value = product.sku;
    document.getElementById('editProductPrice').value = product.price;
    document.getElementById('editProductCount').value = product.quantity;
    document.getElementById('editProductDesc').value = product.description;
    
    const imageContainer = document.getElementById('currentProductImageContainer');
    imageContainer.innerHTML = '';
    if (product.image_path) {
        imageContainer.innerHTML = `
            <p>Current Image:</p>
            <img src="/${product.image_path}" class="product-image" alt="Current Product Image">
        `;
    }
    
    document.querySelectorAll('.modal').forEach(modal => {
        modal.style.display = 'none';
    });
    document.getElementById('editProductModal').style.display = 'block';
}

    // Product Management Functions
    function fetchAndDisplayProducts() {
        axios.get('/productlist')
            .then(response => {
                const products = response.data;
                const tbody = document.getElementById('productsTableBody');
                tbody.innerHTML = ''; // Clear existing rows

                if (products.length > 0) {
                    products.forEach(product => {
                        const row = document.createElement('tr');
                        row.innerHTML = `
                            <td>${product.id}</td>
                            <td>
                                ${product.image_path ? 
                                    `<img src="/${product.image_path}" class="product-image" alt="${product.name}">` : 
                                    'No Image'}
                            </td>
                            <td>${product.name}</td>
                            <td>${product.sku}</td>
                            <td>${product.price}</td>
                            <td>${product.quantity}</td>
                            <td>
                                <button class="action-btn edit-btn" data-id="${product.id}"><i class="fas fa-edit"></i> Edit</button>
                                <button class="action-btn delete-btn" data-id="${product.id}"><i class="fas fa-trash"></i> Delete</button>
                            </td>
                        `;
                        tbody.appendChild(row);
                    });
                    addProductEditDeleteListeners();
                } else {
                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td colspan="7" style="text-align: center;">No products found</td>
                    `;
                    tbody.appendChild(row);
                }
            })
            .catch(error => {
                console.error('Error fetching products:', error);
                alert('Failed to load products. Please try again.');
            });
    }

    function addProductEditDeleteListeners() {
    document.querySelectorAll('.edit-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const productId = this.getAttribute('data-id');
            axios.get(`/products/${productId}`)
                .then(response => {
                    const product = response.data;
                    openEditProductModal(product);
                })
                .catch(error => {
                    console.error('Error fetching product:', error);
                    alert('Failed to load product data. Please try again.');
                });
        });
    });

    // Keep the existing delete functionality
    document.querySelectorAll('.delete-btn').forEach(btn => {
        btn.addEventListener('click', function() {
            const productId = this.getAttribute('data-id');
            if (confirm('Are you sure you want to delete this product?')) {
                axios.delete(`/products/${productId}`)
                    .then(response => {
                        alert('Product deleted successfully');
                        fetchAndDisplayProducts();
                    })
                    .catch(error => {
                        console.error('Error deleting product:', error);
                        alert('Failed to delete product. Please try again.');
                    });
            }
        });
    });
}

    // function addProductEditDeleteListeners() {
    //     document.querySelectorAll('.edit-btn').forEach(btn => {
    //         btn.addEventListener('click', function() {
    //             const productId = this.getAttribute('data-id');
    //             // Implement edit functionality here
    //             alert(`Edit product with ID: ${productId}`);
    //         });
    //     });

    //     document.querySelectorAll('.delete-btn').forEach(btn => {
    //         btn.addEventListener('click', function() {
    //             const productId = this.getAttribute('data-id');
    //             if (confirm('Are you sure you want to delete this product?')) {
    //                 axios.delete(`/products/${productId}`)
    //                     .then(response => {
    //                         alert('Product deleted successfully');
    //                         fetchAndDisplayProducts(); // Refresh the list
    //                     })
    //                     .catch(error => {
    //                         console.error('Error deleting product:', error);
    //                         alert('Failed to delete product. Please try again.');
    //                     });
    //             }
    //         });
    //     });
    // }
    document.querySelector('#ordersModal select').addEventListener('change', function() {
    const status = this.value;
    if (status === 'All Orders') {
        fetchAndDisplayOrders();
    } else {
        // Filter orders by status
        axios.get(`/orderlist?status=${status}`)
            .then(response => {
                // Update the table with filtered orders
                // ... similar to fetchAndDisplayOrders()
            });
    }
});
document.querySelector('#ordersModal input[type="text"]').addEventListener('input', function() {
    const searchTerm = this.value.toLowerCase();
    const rows = document.querySelectorAll('#ordersModal tbody tr');
    
    rows.forEach(row => {
        const text = row.textContent.toLowerCase();
        row.style.display = text.includes(searchTerm) ? '' : 'none';
    });
});

    function fetchAndDisplayOrders() {
    axios.get('/orderlist')
        .then(response => {
            const orders = response.data; 
            const tbody = document.querySelector('#ordersModal table tbody');
            tbody.innerHTML = ''; // Clear existing rows

            if (orders.length > 0) {
                orders.forEach(order => {
                    // Determine status color based on order status
                    let statusColor = '#1a73e8'; // default blue
                    if (order.status === 'Completed') statusColor = '#34a853'; // green
                    if (order.status === 'Cancelled') statusColor = '#ea4335'; // red
                    if (order.status === 'Processing') statusColor = '#fbbc05'; // yellow

                    const row = document.createElement('tr');
                    row.innerHTML = `
                        <td>#${order.order_id}</td>
                        <td>${order.names}</td>
                        <td>${order.phone}</td>
                        <td>${order.product_id}</td>
                        <td>${order.product_price}</td>
                        <td>${order.created_at || 'N/A'}</td>
                        <td><span style="color: ${statusColor};">${order.status || 'N/A'}</span></td>
                        <td>
                            <button class="action-btn edit-btn" data-id="${order.id}">
                                <i class="fas fa-eye"></i> View
                            </button>
                        </td>
                    `;
                    tbody.appendChild(row);
                });
            } else {
                const row = document.createElement('tr');
                row.innerHTML = `
                    <td colspan="6" style="text-align: center;">No orders found</td>
                `;
                tbody.appendChild(row);
            }
        })
        .catch(error => {
            console.error('Error fetching orders:', error);
            alert('Failed to load orders. Please try again.');
        });
}

document.getElementById('publishArticleBtn')?.addEventListener('click', function() {
        const formData = new FormData();
        formData.append('title', document.getElementById('articleTitle').value);
        formData.append('author', document.getElementById('articleAuthor').value);
        formData.append('category', document.getElementById('articleCategory').value);
        formData.append('product_desc', document.getElementById('articleContent').value);
        
        const imageInput = document.getElementById('articleImage');
        if (imageInput.files[0]) {
            formData.append('image', imageInput.files[0]);
        }

        axios.post('/submit-blog', formData, {
            headers: {
                'Content-Type': 'multipart/form-data'
            }
        })
        .then(response => {
            alert('Article published successfully!');
            document.getElementById('addArticleModal').style.display = 'none';
            document.getElementById('newsModal').style.display = 'block';
            document.getElementById('articleForm').reset();
            quillEditor.root.innerHTML = ''; // Clear editor content
            fetchAndDisplayArticles();
        })
        .catch(error => {
            console.error('Error publishing article:', error.response);
            if (error.response && error.response.data) {
                if (error.response.data.errors) {
                    const errors = error.response.data.errors;
                    let errorMessage = '';
                    for (const field in errors) {
                        errorMessage += `${errors[field][0]}\n`;
                    }
                    alert(errorMessage);
                } else {
                    alert(`Failed to publish article: ${error.response.data.message}`);
                }
            } else {
                alert('Failed to publish article. Please try again.');
            }
        });
    });

    // Form Submissions
    // Add event listener for the "Add New User" button
document.getElementById('addUserBtn').addEventListener('click', function() {
    openAddModal('addUserModal'); // Open the "Add User" modal
});
    if (userForm) {
        userForm.addEventListener('submit', function(e) {
            e.preventDefault();
            const formData = {
                fname: document.getElementById('fname').value,
                lname: document.getElementById('lname').value,
                dept: document.getElementById('dept').value,
                phone: document.getElementById('phone').value,
                email: document.getElementById('email').value,
                role: document.getElementById('role').value,
            };

            axios.post('/register-users', formData)
                .then(response => {
                    alert('User added successfully!');
                    addUserModal.style.display = 'none';
                    userManagementModal.style.display = 'block';
                    userForm.reset();
                    fetchAndDisplayUsers();
                })
                .catch(error => {
                    console.error('Error adding user:', error);
                    if (error.response && error.response.data) {
                        alert(`Failed to add user: ${error.response.data.message}`);
                    } else {
                        alert('Failed to add user. Please try again.');
                    }
                });
        });
    }
        // Update User
        document.getElementById('updateUserBtn')?.addEventListener('click', function() {
        const userId = document.getElementById('editUserId').value;
        const formData = {
            fname: document.getElementById('editFname').value,
            lname: document.getElementById('editLname').value,
            dept: document.getElementById('editDept').value,
            phone: document.getElementById('editPhone').value,
            email: document.getElementById('editEmail').value,
            role: document.getElementById('editRole').value,
        };

        axios.put(`/users/${userId}`, formData)
            .then(response => {
                alert('User updated successfully!');
                document.getElementById('editUserModal').style.display = 'none';
                document.getElementById('userManagementModal').style.display = 'block';
                fetchAndDisplayUsers();
            })
            .catch(error => {
                console.error('Error updating user:', error);
                alert(error.response?.data?.message || 'Failed to update user. Please try again.');
            });
    });

    // Update Product
    document.getElementById('updateProductBtn')?.addEventListener('click', function() {
        const productId = document.getElementById('editProductId').value;
        const formData = new FormData();
        formData.append('name', document.getElementById('editProductName').value);
        formData.append('sku', document.getElementById('editProductSku').value);
        formData.append('price', document.getElementById('editProductPrice').value);
        formData.append('quantity', document.getElementById('editProductCount').value);
        formData.append('description', document.getElementById('editProductDesc').value);
        
        const imageInput = document.getElementById('editProductImage');
        if (imageInput.files[0]) {
            formData.append('image', imageInput.files[0]);
        }

        axios.post(`/products/${productId}`, formData, {
            headers: {
                'Content-Type': 'multipart/form-data'
            },
            params: {
                _method: 'PUT'
            }
        })
        .then(response => {
            alert('Product updated successfully!');
            document.getElementById('editProductModal').style.display = 'none';
            document.getElementById('productsModal').style.display = 'block';
            fetchAndDisplayProducts();
        })
        .catch(error => {
            console.error('Error updating product:', error);
            alert(error.response?.data?.message || 'Failed to update product. Please try again.');
        });
    });

    // Product Form Submission
    document.getElementById('saveProductBtn')?.addEventListener('click', function() {
        const form = document.getElementById('productForm');
        const formData = new FormData(form);

        axios.post('/product/store', formData, {
            headers: {
                'Content-Type': 'multipart/form-data'
            }
        })
        .then(response => {
            alert('Product added successfully!');
            document.getElementById('addProductModal').style.display = 'none';
            document.getElementById('productsModal').style.display = 'block';
            form.reset();
            fetchAndDisplayProducts();
        })
        .catch(error => {
            console.error('Error adding product:', error);
            if (error.response && error.response.data) {
                if (error.response.data.errors) {
                    const errors = error.response.data.errors;
                    let errorMessage = '';
                    for (const field in errors) {
                        errorMessage += `${errors[field][0]}\n`;
                    }
                    alert(errorMessage);
                } else {
                    alert(`Failed to add product: ${error.response.data.message}`);
                }
            } else {
                alert('Failed to add product. Please try again.');
            }
        });
    });

    // Device Form Submission
    const deviceForm = document.getElementById('deviceForm');
    if (deviceForm) {
        deviceForm.addEventListener('submit', function(e) {
            e.preventDefault();
            alert('Device added successfully!');
            document.getElementById('addDeviceModal').style.display = 'none';
            document.getElementById('devicesModal').style.display = 'block';
            deviceForm.reset();
        });
    }

    // Article Form Submission
    const articleForm = document.getElementById('articleForm');
    if (articleForm) {
        articleForm.addEventListener('submit', function(e) {
            e.preventDefault();
            alert('Article published successfully!');
            document.getElementById('addArticleModal').style.display = 'none';
            document.getElementById('newsModal').style.display = 'block';
            articleForm.reset();
        });
    }

    // Close modals
    closeButtons.forEach(button => {
        button.addEventListener('click', function() {
            document.querySelectorAll('.modal').forEach(modal => {
                modal.style.display = 'none';
            });
        });
    });

    // Close modal when clicking outside
    window.addEventListener('click', function(event) {
        if (event.target.classList.contains('modal')) {
            event.target.style.display = 'none';
        }
    });

    // Logout functionality
    const logoutBtn = document.getElementById('logoutBtn');
    if (logoutBtn) {
        logoutBtn.addEventListener('click', function() {
            document.querySelectorAll('.sidebar li').forEach(item => {
                item.classList.remove('active');
            });
            this.classList.add('active');
            window.location.href = '/signout';
        });
    }
});
    </script>


</body>

</html>