@extends('layouts.app')

@section('content')
<div class="card card-full">
    <h3><i class="fas fa-plus-circle"></i> Add New IoT Device</h3>
    
    <form method="POST" action="{{ route('devices.store') }}" enctype="multipart/form-data">
        @csrf

        <div class="form-group">
            <label for="name">Device Name</label>
            <input type="text" class="form-control" id="name" name="name" required>
        </div>

        <div class="form-group">
            <label for="serial">Serial Number</label>
            <input type="text" class="form-control" id="serial" name="serial" required>
        </div>

        <div class="form-group">
            <label for="image">Device Image</label>
            <input type="file" class="form-control" id="image" name="image" accept="image/*" required>
        </div>

        <div class="form-group">
            <label for="latitude">Latitude</label>
            <input type="number" step="any" class="form-control" id="latitude" name="latitude" required>
        </div>

        <div class="form-group">
            <label for="longitude">Longitude</label>
            <input type="number" step="any" class="form-control" id="longitude" name="longitude" required>
        </div>

        <div class="form-group">
            <label for="location">Location</label>
            <input type="text" class="form-control" id="location" name="location" required>
        </div>

        <div class="modal-footer">
            <a href="{{ route('devices.list') }}" class="btn btn-secondary">Cancel</a>
            <button type="submit" class="btn btn-primary">Save Device</button>
        </div>
    </form>
</div>
@endsection