<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('orders', function (Blueprint $table) {
            $table->id(); 
            $table->string('phone');
            $table->string('email');
            $table->string('county');
            $table->string('street_address');
            $table->string('house_number_street_name');
            $table->string('apartment_suite_unit')->nullable(); 
            $table->string('town_city');
            $table->string('state_county');
            $table->string('postcode_zip');
            $table->string('order_id')->unique(); 
            $table->string('product_id');
            $table->decimal('product_price', 10, 2);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('orders');
    }
};
