<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\IotDevice;


class DevicesController extends Controller
{
    public function getDevices(){
     $devices = IotDevice::all();

        return view('devices.list', compact('devices'));
    }
    public function createDevice(){
        return view('devices.add-device');
    }
   public function showDeviceInfo($id)
   {
       $device = IotDevice::findOrFail($id);

       return view('devices.device-info', [
           'latitude' => $device->latitude,
           'longitude' => $device->longitude,
           'device' => $device,
       ]);
   }
    public function saveIot(Request $request)
    {
        $request->validate([
            'name' => 'required|string|max:255',
            'serial' => 'required|string|max:255',
            'image' => 'required|image|mimes:jpg,png,jpeg,gif|max:2048',
          'latitude' => 'required|numeric|between:-90,90',
          'longitude' => 'required|numeric|between:-180,180',
            'location' => 'required|string|max:255',
        ]);

        $imagePath = $request->file('image')->store('images', 'public');


        $device = IotDevice::create([
            'name' => $request->name,
            'serial' => $request->serial,
            'image' => $imagePath,
            'latitude' => $request->latitude,
            'longitude' => $request->longitude,
            'location' => $request->location,
        ]);

        return redirect()->back()->with('success', 'IoT Device added successfully.');
    }
}
