<?php
namespace App\Http\Controllers;
use BotMan\BotMan\BotMan;
use Illuminate\Http\Request;
use BotMan\BotMan\Messages\Incoming\Answer;
class BotManController extends Controller
{
    public function handle()
    {
     $botman = app('botman');
        // Listen for any message
     $botman->hears('{message}', function($botman, $message) {
            $message = strtolower($message);
      if ($message == 'hi') {
       $this->askName($botman);
      }
      else {
       $botman->reply("Start a conversation by saying hi.");
      }
     });
     $botman->listen();
    }
    /**
     * Ask the user for their name when they say 'hi'.
     */
    public function askName($botman)
    {
     // For fewer questions, you can use the inline conversation approach as shown below. Alternatively, use a dedicated conversation class for multi-step conversations
     $botman->ask('Hello! What is your name?', function(Answer $answer, $conversation) {
            // Capture the user's answer
      $name = $answer->getText();
            // Respond with a personalized message
      $this->say('Nice to meet you, ' . $name);
      //Continue inline conversation.
      $conversation->ask('Can you advise about your email address.', function(Answer $answer, $conversation){
       $email = $answer->getText();
       $this->say('Email : '.$email);
      });
     });
    }
}
