<?php

namespace App\Http\Controllers;
use Carbon\Carbon;
use Intervention\Image\Facades\Image;

use Illuminate\Http\Request;
use App\Models\BlogPost;

class BlogController extends Controller
{
    public function create()
    {
        return view('majik.addblog');
    }

    public function getBlogDetails($id)
    {
        $blog = BlogPost::findOrFail($id);
        return view('majik.blog', compact('blog'));
        // return response()->json($blog);

    }

    public function store(Request $request)
    {
        // Get the authenticated user
        $userr = auth()->user();

        // Validate the incoming request data
        $request->validate([
            'title' => 'required|string|max:255',
            'product_desc' => 'required',
            'image' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
        ]);

        $imagePath = null;

        if ($request->hasFile('image')) {
            $image = $request->file('image');

            // Resize the image using Intervention Image
            $resizedImage = Image::make($image)->resize(800, null, function ($constraint) {
                $constraint->aspectRatio();
            })->encode('jpg');

            // Define the target directory and file name
            $targetDirectory = public_path('assets/web-new/assets/images/blogs/');
            $fileName = uniqid() . '.jpg';
            $imagePath = 'assets/web-new/assets/images/blogs/' . $fileName;

            // Ensure the target directory exists
            if (!file_exists($targetDirectory)) {
                mkdir($targetDirectory, 0777, true);
            }

            // Save the resized image directly to the public folder
            $resizedImage->save($targetDirectory . $fileName);
        }

        // Create the blog post record in the database
        BlogPost::create([
            'title' => $request->title,
            'content' => $request->product_desc,
            'image' => $imagePath, // Store the relative path to the image
            'author' => $userr->fname,
            'posted_at' => Carbon::now(),
        ]);

        return redirect()->back()->with('success', 'Blog post added successfully.');
    }

    public function getBlogs()
    {
        $blogs = BlogPost::all();
        // return view('majik.blogs', compact('blogs'));
        return response()->json($blogs);

    }
}